/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.MultiWrapDynaBean;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.junit.Assert;
import org.junit.Test;

public class TestMultiWrapDynaBean {
    private static final String MAPPED_PROPERTY = "testMappedProperty";
    private BasicBuilderParameters params;
    private WrappedBeanTestImpl wrapBean;
    private LazyDynaBean wrapDynaBean;

    private MultiWrapDynaBean createBean(boolean withDynaBean) {
        this.params = new BasicBuilderParameters();
        this.wrapBean = new WrappedBeanTestImpl();
        ArrayList<Object> beans = new ArrayList<Object>();
        beans.add(this.params);
        beans.add(this.wrapBean);
        if (withDynaBean) {
            this.wrapDynaBean = new LazyDynaBean();
            this.wrapDynaBean.set(MAPPED_PROPERTY, "someKey", (Object)"somValue");
            beans.add(this.wrapDynaBean);
        }
        return new MultiWrapDynaBean(beans);
    }

    @Test
    public void testSetSimpleProperty() throws Exception {
        PropertyUtils.setProperty((Object)this.createBean(false), (String)"throwExceptionOnMissing", (Object)Boolean.TRUE);
        Assert.assertEquals((String)"Property not set", (Object)Boolean.TRUE, this.params.getParameters().get("throwExceptionOnMissing"));
    }

    @Test
    public void testGetSimpleProperty() throws Exception {
        MultiWrapDynaBean bean = this.createBean(false);
        String text = "testText";
        this.wrapBean.setText(text);
        Assert.assertEquals((String)"Wrong value", (Object)text, (Object)PropertyUtils.getProperty((Object)bean, (String)"text"));
    }

    @Test
    public void testSetIndexedProperty() throws Exception {
        PropertyUtils.setIndexedProperty((Object)this.createBean(false), (String)"indexedProperty", (int)1, (Object)42);
        Assert.assertEquals((String)"Property not set", (long)42L, (long)this.wrapBean.getIndexedProperty(1));
    }

    @Test
    public void testGetIndexedProperty() throws Exception {
        MultiWrapDynaBean bean = this.createBean(false);
        this.wrapBean.setIndexedProperty(3, 20121117);
        Assert.assertEquals((String)"Wrong value", (Object)20121117, (Object)PropertyUtils.getIndexedProperty((Object)bean, (String)"indexedProperty", (int)3));
    }

    @Test
    public void testSetMappedProperty() throws Exception {
        MultiWrapDynaBean bean = this.createBean(true);
        String key = "testKey";
        String text = "Hello World";
        PropertyUtils.setMappedProperty((Object)bean, (String)MAPPED_PROPERTY, (String)key, (Object)text);
        Assert.assertEquals((String)"Property not set", (Object)text, (Object)this.wrapDynaBean.get(MAPPED_PROPERTY, key));
    }

    @Test
    public void testGetMappedProperty() throws Exception {
        MultiWrapDynaBean bean = this.createBean(true);
        String key = "testKey";
        String value = "Hello World";
        this.wrapDynaBean.set(MAPPED_PROPERTY, key, (Object)value);
        Assert.assertEquals((String)"Wrong value", (Object)value, (Object)PropertyUtils.getMappedProperty((Object)bean, (String)MAPPED_PROPERTY, (String)key));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetPropertyUnknown() {
        this.createBean(false).get("unknown property");
    }

    @Test
    public void testGetDynaClass() {
        DynaClass cls = this.createBean(false).getDynaClass();
        Assert.assertNotNull((String)"Property not found (1)", (Object)cls.getDynaProperty("throwExceptionOnMissing"));
        Assert.assertNotNull((String)"Property not found (2)", (Object)cls.getDynaProperty("text"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetDynaClassNewInstance() throws Exception {
        this.createBean(false).getDynaClass().newInstance();
    }

    @Test
    public void testGetDynaClassName() {
        Assert.assertNull((String)"Got a class name", (Object)this.createBean(false).getDynaClass().getName());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemove() {
        this.createBean(false).remove(MAPPED_PROPERTY, "someKey");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testContains() {
        this.createBean(false).contains(MAPPED_PROPERTY, "someKey");
    }

    @Test
    public void testOrderOfProperties() throws Exception {
        ArrayList<Object> beans = new ArrayList<Object>();
        this.params = new BasicBuilderParameters();
        beans.add(this.params);
        beans.add(new FileBasedBuilderParametersImpl());
        for (int i = 0; i < 32; ++i) {
            beans.add(new BasicBuilderParameters());
        }
        MultiWrapDynaBean bean = new MultiWrapDynaBean(beans);
        DefaultListDelimiterHandler listHandler = new DefaultListDelimiterHandler('+');
        PropertyUtils.setProperty((Object)bean, (String)"throwExceptionOnMissing", (Object)Boolean.TRUE);
        PropertyUtils.setProperty((Object)bean, (String)"listDelimiterHandler", (Object)listHandler);
        Map map = this.params.getParameters();
        Assert.assertEquals((String)"Exception flag not set", (Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
        Assert.assertEquals((String)"List delimiter handler not set", (Object)listHandler, map.get("listDelimiterHandler"));
    }

    public static class WrappedBeanTestImpl {
        private final Map<String, String> mapProperties = new HashMap<String, String>();
        private final int[] indexedValues = new int[8];
        private String text;

        public String getMapProperty(String key) {
            return this.mapProperties.get(key);
        }

        public void setMapProperty(String key, String value) {
            this.mapProperties.put(key, value);
        }

        public int getIndexedProperty(int idx) {
            return this.indexedValues[idx];
        }

        public void setIndexedProperty(int idx, int value) {
            this.indexedValues[idx] = value;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

