/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.junit;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.junit.ObjectToStringComparator;
import org.apache.commons.collections4.junit.SetDefaultLocaleTestRule;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class AbstractAvailableLocalesTest {
    private final Locale locale;
    @Rule
    public final SetDefaultLocaleTestRule rule;

    @Parameterized.Parameters(name="{0}")
    public static Locale[] getSortedAvailableLocales() {
        Locale[] availableLocales = Locale.getAvailableLocales();
        Arrays.sort(availableLocales, new ObjectToStringComparator());
        return availableLocales;
    }

    public static List<Locale> getSortedDeclaredLocales() {
        Field[] allFields = FieldUtils.getAllFields(Locale.class);
        ArrayList<Locale> availableLocales = new ArrayList<Locale>(allFields.length);
        for (Field field : allFields) {
            int modifiers = field.getModifiers();
            if (field.getType() != Locale.class || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            try {
                availableLocales.add((Locale)field.get(Locale.class));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new IllegalStateException("Field " + field, e);
            }
        }
        Collections.sort(availableLocales, new ObjectToStringComparator());
        return availableLocales;
    }

    public AbstractAvailableLocalesTest(Locale locale) {
        this.locale = locale;
        this.rule = new SetDefaultLocaleTestRule(locale);
    }

    public Locale getLocale() {
        return this.locale;
    }
}

