/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.ZippingIterator;

public class ZippingIteratorTest
extends AbstractIteratorTest<Integer> {
    private ArrayList<Integer> evens = null;
    private ArrayList<Integer> odds = null;
    private ArrayList<Integer> fib = null;

    public ZippingIteratorTest(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.evens = new ArrayList();
        this.odds = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            if (0 == i % 2) {
                this.evens.add(i);
                continue;
            }
            this.odds.add(i);
        }
        this.fib = new ArrayList();
        this.fib.add(1);
        this.fib.add(1);
        this.fib.add(2);
        this.fib.add(3);
        this.fib.add(5);
        this.fib.add(8);
        this.fib.add(13);
        this.fib.add(21);
    }

    @Override
    public ZippingIterator<Integer> makeEmptyIterator() {
        return new ZippingIterator(new Iterator[]{IteratorUtils.emptyIterator()});
    }

    @Override
    public ZippingIterator<Integer> makeObject() {
        return new ZippingIterator(this.evens.iterator(), this.odds.iterator(), this.fib.iterator());
    }

    public void testIterateEven() {
        ZippingIterator iter = new ZippingIterator(new Iterator[]{this.evens.iterator()});
        for (int i = 0; i < this.evens.size(); ++i) {
            ZippingIteratorTest.assertTrue((boolean)iter.hasNext());
            ZippingIteratorTest.assertEquals((Object)this.evens.get(i), (Object)iter.next());
        }
        ZippingIteratorTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    public void testIterateEvenOdd() {
        ZippingIterator iter = new ZippingIterator(this.evens.iterator(), this.odds.iterator());
        for (int i = 0; i < 20; ++i) {
            ZippingIteratorTest.assertTrue((boolean)iter.hasNext());
            ZippingIteratorTest.assertEquals((Object)i, (Object)iter.next());
        }
        ZippingIteratorTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    public void testIterateOddEven() {
        ZippingIterator iter = new ZippingIterator(this.odds.iterator(), this.evens.iterator());
        int j = 0;
        for (int i = 0; i < 20; ++i) {
            ZippingIteratorTest.assertTrue((boolean)iter.hasNext());
            int val = (Integer)iter.next();
            if (i % 2 == 0) {
                ZippingIteratorTest.assertEquals((int)this.odds.get(j), (int)val);
                continue;
            }
            ZippingIteratorTest.assertEquals((int)this.evens.get(j), (int)val);
            ++j;
        }
        ZippingIteratorTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    public void testIterateEvenEven() {
        ZippingIterator iter = new ZippingIterator(this.evens.iterator(), this.evens.iterator());
        for (int i = 0; i < this.evens.size(); ++i) {
            ZippingIteratorTest.assertTrue((boolean)iter.hasNext());
            ZippingIteratorTest.assertEquals((Object)this.evens.get(i), (Object)iter.next());
            ZippingIteratorTest.assertTrue((boolean)iter.hasNext());
            ZippingIteratorTest.assertEquals((Object)this.evens.get(i), (Object)iter.next());
        }
        ZippingIteratorTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    public void testIterateFibEvenOdd() {
        ZippingIterator iter = new ZippingIterator(this.fib.iterator(), this.evens.iterator(), this.odds.iterator());
        ZippingIteratorTest.assertEquals((Object)1, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)0, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)1, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)1, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)2, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)3, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)2, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)4, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)5, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)3, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)6, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)7, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)5, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)8, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)9, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)8, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)10, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)11, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)13, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)12, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)13, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)21, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)14, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)15, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)16, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)17, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)18, (Object)iter.next());
        ZippingIteratorTest.assertEquals((Object)19, (Object)iter.next());
        ZippingIteratorTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    public void testRemoveFromSingle() {
        ZippingIterator iter = new ZippingIterator(new Iterator[]{this.evens.iterator()});
        int expectedSize = this.evens.size();
        while (iter.hasNext()) {
            Object o = iter.next();
            Integer val = (Integer)o;
            if (val % 4 != 0) continue;
            --expectedSize;
            iter.remove();
        }
        ZippingIteratorTest.assertEquals((int)expectedSize, (int)this.evens.size());
    }

    public void testRemoveFromDouble() {
        ZippingIterator iter = new ZippingIterator(this.evens.iterator(), this.odds.iterator());
        int expectedSize = this.evens.size() + this.odds.size();
        while (iter.hasNext()) {
            Object o = iter.next();
            Integer val = (Integer)o;
            if (val % 4 != 0 && val % 3 != 0) continue;
            --expectedSize;
            iter.remove();
        }
        ZippingIteratorTest.assertEquals((int)expectedSize, (int)(this.evens.size() + this.odds.size()));
    }
}

