/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.UnmodifiableIterator;

public class UnmodifiableIteratorTest<E>
extends AbstractIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three"};
    protected List<E> testList;

    public UnmodifiableIteratorTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testList = new ArrayList<Object>(Arrays.asList((Object[])this.testArray));
    }

    @Override
    public Iterator<E> makeEmptyIterator() {
        return UnmodifiableIterator.unmodifiableIterator(Collections.emptyList().iterator());
    }

    @Override
    public Iterator<E> makeObject() {
        return UnmodifiableIterator.unmodifiableIterator(this.testList.iterator());
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    public void testIterator() {
        UnmodifiableIteratorTest.assertTrue((boolean)(this.makeEmptyIterator() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        Iterator<E> it = this.makeObject();
        UnmodifiableIteratorTest.assertSame((Object)it, (Object)UnmodifiableIterator.unmodifiableIterator((Iterator)it));
        it = this.testList.iterator();
        UnmodifiableIteratorTest.assertTrue((it != UnmodifiableIterator.unmodifiableIterator(it) ? 1 : 0) != 0);
        try {
            UnmodifiableIterator.unmodifiableIterator(null);
            UnmodifiableIteratorTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

