/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.SingletonIterator;

public class SingletonIterator2Test<E>
extends AbstractIteratorTest<E> {
    private static final Object testValue = "foo";

    public SingletonIterator2Test(String testName) {
        super(testName);
    }

    @Override
    public SingletonIterator<E> makeEmptyIterator() {
        SingletonIterator iter = new SingletonIterator(testValue);
        iter.next();
        iter.remove();
        iter.reset();
        return iter;
    }

    @Override
    public SingletonIterator<E> makeObject() {
        return new SingletonIterator(testValue, false);
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Override
    public boolean supportsEmptyIterator() {
        return false;
    }

    public void testIterator() {
        SingletonIterator<E> iter = this.makeObject();
        SingletonIterator2Test.assertTrue((String)"Iterator has a first item", (boolean)iter.hasNext());
        Object iterValue = iter.next();
        SingletonIterator2Test.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        SingletonIterator2Test.assertTrue((String)"Iterator should now be empty", (!iter.hasNext() ? 1 : 0) != 0);
        try {
            iter.next();
        }
        catch (Exception e) {
            SingletonIterator2Test.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
    }

    public void testReset() {
        SingletonIterator<E> it = this.makeObject();
        SingletonIterator2Test.assertEquals((boolean)true, (boolean)it.hasNext());
        SingletonIterator2Test.assertEquals((Object)testValue, (Object)it.next());
        SingletonIterator2Test.assertEquals((boolean)false, (boolean)it.hasNext());
        it.reset();
        SingletonIterator2Test.assertEquals((boolean)true, (boolean)it.hasNext());
        SingletonIterator2Test.assertEquals((Object)testValue, (Object)it.next());
        SingletonIterator2Test.assertEquals((boolean)false, (boolean)it.hasNext());
        it.reset();
        it.reset();
        SingletonIterator2Test.assertEquals((boolean)true, (boolean)it.hasNext());
    }
}

