/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.PushbackIterator;
import org.junit.Test;

public class PushbackIteratorTest<E>
extends AbstractIteratorTest<E> {
    private final String[] testArray = new String[]{"a", "b", "c"};
    private List<E> testList;

    public PushbackIteratorTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testList = new ArrayList<Object>(Arrays.asList((Object[])this.testArray));
    }

    @Override
    public Iterator<E> makeEmptyIterator() {
        return PushbackIterator.pushbackIterator(Collections.emptyList().iterator());
    }

    @Override
    public PushbackIterator<E> makeObject() {
        return PushbackIterator.pushbackIterator(this.testList.iterator());
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Test
    public void testNormalIteration() {
        PushbackIterator<E> iter = this.makeObject();
        PushbackIteratorTest.assertEquals((Object)"a", (Object)iter.next());
        PushbackIteratorTest.assertEquals((Object)"b", (Object)iter.next());
        PushbackIteratorTest.assertEquals((Object)"c", (Object)iter.next());
        PushbackIteratorTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testImmediatePushback() {
        PushbackIterator<E> iter = this.makeObject();
        iter.pushback((Object)"x");
        PushbackIteratorTest.assertEquals((Object)"x", (Object)iter.next());
        PushbackIteratorTest.assertEquals((Object)"a", (Object)iter.next());
        this.validate((Iterator<E>)iter, "b", "c");
    }

    @Test
    public void testDelayedPushback() {
        PushbackIterator<E> iter = this.makeObject();
        PushbackIteratorTest.assertEquals((Object)"a", (Object)iter.next());
        iter.pushback((Object)"x");
        PushbackIteratorTest.assertEquals((Object)"x", (Object)iter.next());
        PushbackIteratorTest.assertEquals((Object)"b", (Object)iter.next());
        this.validate((Iterator<E>)iter, "c");
    }

    @Test
    public void testMultiplePushback() {
        PushbackIterator<E> iter = this.makeObject();
        PushbackIteratorTest.assertEquals((Object)"a", (Object)iter.next());
        iter.pushback((Object)"x");
        iter.pushback((Object)"y");
        PushbackIteratorTest.assertEquals((Object)"y", (Object)iter.next());
        PushbackIteratorTest.assertEquals((Object)"x", (Object)iter.next());
        PushbackIteratorTest.assertEquals((Object)"b", (Object)iter.next());
        this.validate((Iterator<E>)iter, "c");
    }

    private void validate(Iterator<E> iter, Object ... items) {
        for (Object x : items) {
            PushbackIteratorTest.assertTrue((boolean)iter.hasNext());
            PushbackIteratorTest.assertEquals((Object)x, iter.next());
        }
        PushbackIteratorTest.assertFalse((boolean)iter.hasNext());
    }
}

