/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.LoopingIterator;
import org.junit.Assert;
import org.junit.Test;

public class LoopingIteratorTest {
    @Test
    public void testConstructorEx() throws Exception {
        try {
            new LoopingIterator(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testLooping0() throws Exception {
        ArrayList list = new ArrayList();
        LoopingIterator loop = new LoopingIterator(list);
        Assert.assertTrue((String)"hasNext should return false", (!loop.hasNext() ? 1 : 0) != 0);
        try {
            loop.next();
            Assert.fail((String)"NoSuchElementException was not thrown during next() call.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testLooping1() throws Exception {
        List<String> list = Arrays.asList("a");
        LoopingIterator loop = new LoopingIterator(list);
        Assert.assertTrue((String)"1st hasNext should return true", (boolean)loop.hasNext());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertTrue((String)"2nd hasNext should return true", (boolean)loop.hasNext());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertTrue((String)"3rd hasNext should return true", (boolean)loop.hasNext());
        Assert.assertEquals((Object)"a", (Object)loop.next());
    }

    @Test
    public void testLooping2() throws Exception {
        List<String> list = Arrays.asList("a", "b");
        LoopingIterator loop = new LoopingIterator(list);
        Assert.assertTrue((String)"1st hasNext should return true", (boolean)loop.hasNext());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertTrue((String)"2nd hasNext should return true", (boolean)loop.hasNext());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        Assert.assertTrue((String)"3rd hasNext should return true", (boolean)loop.hasNext());
        Assert.assertEquals((Object)"a", (Object)loop.next());
    }

    @Test
    public void testLooping3() throws Exception {
        List<String> list = Arrays.asList("a", "b", "c");
        LoopingIterator loop = new LoopingIterator(list);
        Assert.assertTrue((String)"1st hasNext should return true", (boolean)loop.hasNext());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertTrue((String)"2nd hasNext should return true", (boolean)loop.hasNext());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        Assert.assertTrue((String)"3rd hasNext should return true", (boolean)loop.hasNext());
        Assert.assertEquals((Object)"c", (Object)loop.next());
        Assert.assertTrue((String)"4th hasNext should return true", (boolean)loop.hasNext());
        Assert.assertEquals((Object)"a", (Object)loop.next());
    }

    @Test
    public void testRemoving1() throws Exception {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        LoopingIterator loop = new LoopingIterator(list);
        Assert.assertEquals((String)"list should have 3 elements.", (long)3L, (long)list.size());
        Assert.assertTrue((String)"1st hasNext should return true", (boolean)loop.hasNext());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        loop.remove();
        Assert.assertEquals((String)"list should have 2 elements.", (long)2L, (long)list.size());
        Assert.assertTrue((String)"2nd hasNext should return true", (boolean)loop.hasNext());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        loop.remove();
        Assert.assertEquals((String)"list should have 1 elements.", (long)1L, (long)list.size());
        Assert.assertTrue((String)"3rd hasNext should return true", (boolean)loop.hasNext());
        Assert.assertEquals((Object)"c", (Object)loop.next());
        loop.remove();
        Assert.assertEquals((String)"list should have 0 elements.", (long)0L, (long)list.size());
        Assert.assertFalse((String)"4th hasNext should return false", (boolean)loop.hasNext());
        try {
            loop.next();
            Assert.fail((String)"Expected NoSuchElementException to be thrown.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testReset() throws Exception {
        List<String> list = Arrays.asList("a", "b", "c");
        LoopingIterator loop = new LoopingIterator(list);
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        loop.reset();
        Assert.assertEquals((Object)"a", (Object)loop.next());
        loop.reset();
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        Assert.assertEquals((Object)"c", (Object)loop.next());
        loop.reset();
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        Assert.assertEquals((Object)"c", (Object)loop.next());
    }

    @Test
    public void testSize() throws Exception {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        LoopingIterator loop = new LoopingIterator(list);
        Assert.assertEquals((long)3L, (long)loop.size());
        loop.next();
        loop.next();
        Assert.assertEquals((long)3L, (long)loop.size());
        loop.reset();
        Assert.assertEquals((long)3L, (long)loop.size());
        loop.next();
        loop.remove();
        Assert.assertEquals((long)2L, (long)loop.size());
    }
}

