/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.util.Arrays;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.bag.AbstractSortedBagTest;
import org.apache.commons.collections4.bag.TreeBag;
import org.apache.commons.collections4.bag.UnmodifiableSortedBag;

public class UnmodifiableSortedBagTest<E>
extends AbstractSortedBagTest<E> {
    public UnmodifiableSortedBagTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(UnmodifiableSortedBagTest.class);
    }

    @Override
    public SortedBag<E> makeObject() {
        return UnmodifiableSortedBag.unmodifiableSortedBag((SortedBag)new TreeBag());
    }

    @Override
    public SortedBag<E> makeFullCollection() {
        TreeBag bag = new TreeBag();
        bag.addAll(Arrays.asList(this.getFullElements()));
        return UnmodifiableSortedBag.unmodifiableSortedBag((SortedBag)bag);
    }

    @Override
    public SortedBag<E> getCollection() {
        return super.getCollection();
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    public void testUnmodifiable() {
        UnmodifiableSortedBagTest.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        UnmodifiableSortedBagTest.assertTrue((boolean)(this.makeFullCollection() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        SortedBag<E> queue = this.makeFullCollection();
        UnmodifiableSortedBagTest.assertSame(queue, (Object)UnmodifiableSortedBag.unmodifiableSortedBag(queue));
        try {
            UnmodifiableSortedBag.unmodifiableSortedBag(null);
            UnmodifiableSortedBagTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

