/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.collections4.EnumerationUtils;
import org.junit.Assert;
import org.junit.Test;

public class EnumerationUtilsTest {
    public static final String TO_LIST_FIXTURE = "this is a test";

    @Test
    public void testToListWithStringTokenizer() {
        ArrayList<String> expectedList1 = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(TO_LIST_FIXTURE);
        while (st.hasMoreTokens()) {
            expectedList1.add(st.nextToken());
        }
        ArrayList<String> expectedList2 = new ArrayList<String>();
        expectedList2.add("this");
        expectedList2.add("is");
        expectedList2.add("a");
        expectedList2.add("test");
        List actualList = EnumerationUtils.toList((StringTokenizer)new StringTokenizer(TO_LIST_FIXTURE));
        Assert.assertEquals(expectedList1, expectedList2);
        Assert.assertEquals(expectedList1, (Object)actualList);
        Assert.assertEquals(expectedList2, (Object)actualList);
    }

    @Test
    public void testToListWithHashtable() {
        Hashtable<String, Integer> expected = new Hashtable<String, Integer>();
        expected.put("one", 1);
        expected.put("two", 2);
        expected.put("three", 3);
        List actualEltList = EnumerationUtils.toList(expected.elements());
        Assert.assertEquals((long)expected.size(), (long)actualEltList.size());
        Assert.assertTrue((boolean)actualEltList.contains(1));
        Assert.assertTrue((boolean)actualEltList.contains(2));
        Assert.assertTrue((boolean)actualEltList.contains(3));
        ArrayList<Integer> expectedEltList = new ArrayList<Integer>();
        expectedEltList.add(1);
        expectedEltList.add(2);
        expectedEltList.add(3);
        Assert.assertTrue((boolean)actualEltList.containsAll(expectedEltList));
        List actualKeyList = EnumerationUtils.toList(expected.keys());
        Assert.assertEquals((long)expected.size(), (long)actualEltList.size());
        Assert.assertTrue((boolean)actualKeyList.contains("one"));
        Assert.assertTrue((boolean)actualKeyList.contains("two"));
        Assert.assertTrue((boolean)actualKeyList.contains("three"));
        ArrayList<String> expectedKeyList = new ArrayList<String>();
        expectedKeyList.add("one");
        expectedKeyList.add("two");
        expectedKeyList.add("three");
        Assert.assertTrue((boolean)actualKeyList.containsAll(expectedKeyList));
    }

    @Test
    public void getFromEnumeration() throws Exception {
        Vector<String> vector = new Vector<String>();
        vector.addElement("zero");
        vector.addElement("one");
        Enumeration en = vector.elements();
        Assert.assertEquals((Object)"zero", (Object)EnumerationUtils.get(en, (int)0));
        en = vector.elements();
        Assert.assertEquals((Object)"one", (Object)EnumerationUtils.get(en, (int)1));
        try {
            EnumerationUtils.get(en, (int)3);
            Assert.fail((String)"Expecting IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertTrue((!en.hasMoreElements() ? 1 : 0) != 0);
    }
}

