/*
 * Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.jxpath.xml;

import java.io.InputStream;

import org.apache.commons.jxpath.JXPathException;
import org.jdom.input.SAXBuilder;

/**
 * An implementation of the XMLParser interface that produces a JDOM Document.
 *
 * @author Dmitri Plotnikov
 * @version $Revision: 1.8 $ $Date: 2004-02-29 14:17:46 +0000 (Sun, 29 Feb 2004) $
 */
public class JDOMParser extends XMLParser2 {
    
    public Object parseXML(InputStream stream) {
        if (!isNamespaceAware()) {
            throw new JXPathException("JDOM parser configuration error. JDOM "
                    + "does not support the namespaceAware=false setting.");
        }
        
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(isExpandEntityReferences());
            builder.setIgnoringElementContentWhitespace(
                    isIgnoringElementContentWhitespace());
            builder.setValidation(isValidating());
            return builder.build(stream);
        }
        catch (Exception ex) {
            throw new JXPathException("JDOM parser error", ex);
        }
    }
}