/*
 * Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.jxpath.ri.axes;

import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodePointer;

/**
 * EvalContext  that returns the current node from the parent context if the
 * test succeeds.
 *
 * @author Dmitri Plotnikov
 * @version $Revision: 1.12 $ $Date: 2004-02-29 14:17:46 +0000 (Sun, 29 Feb 2004) $
 */
public class SelfContext extends EvalContext {
    private NodeTest nodeTest;
    private boolean startedSet = false;
    private NodePointer nodePointer;

    public SelfContext(EvalContext parentContext, NodeTest nodeTest) {
        super(parentContext);
        this.nodeTest = nodeTest;
    }

    public Pointer getSingleNodePointer() {
        return parentContext.getSingleNodePointer();
    }

    public NodePointer getCurrentNodePointer() {
        if (position == 0) {
            if (!setPosition(1)) {
                return null;
            }
        }
        return nodePointer;
    }

    public boolean nextNode() {
        return setPosition(getCurrentPosition() + 1);
    }

    public void reset() {
        super.reset();
        startedSet = false;
    }

    public boolean setPosition(int position) {
        if (position != 1) {
            return false;
        }
        super.setPosition(position);
        if (!startedSet) {
            startedSet = true;
            nodePointer = (NodePointer) parentContext.getCurrentNodePointer();
        }

        if (nodePointer == null) {
            return false;
        }

        return nodeTest == null || nodePointer.testNode(nodeTest);
    }
}