/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.simulacron;

import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.testinfra.CassandraResourceRule;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.simulacron.common.cluster.ClusterSpec;
import com.datastax.oss.simulacron.server.AddressResolver;
import com.datastax.oss.simulacron.server.BoundCluster;
import com.datastax.oss.simulacron.server.BoundDataCenter;
import com.datastax.oss.simulacron.server.Inet4Resolver;
import com.datastax.oss.simulacron.server.Server;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class SimulacronRule
extends CassandraResourceRule {
    public static final Server server = Server.builder().withAddressResolver((AddressResolver)new Inet4Resolver(9043){

        public void release(SocketAddress address) {
        }
    }).build();
    private final ClusterSpec clusterSpec;
    private BoundCluster boundCluster;
    private final AtomicBoolean started = new AtomicBoolean();

    public SimulacronRule(ClusterSpec clusterSpec) {
        this.clusterSpec = clusterSpec;
    }

    public SimulacronRule(ClusterSpec.Builder clusterSpec) {
        this(clusterSpec.build());
    }

    public BoundCluster cluster() {
        return this.boundCluster;
    }

    public BoundCluster getBoundCluster() {
        return this.boundCluster;
    }

    protected void before() {
        if (this.started.compareAndSet(false, true)) {
            this.boundCluster = server.register(this.clusterSpec);
        }
    }

    protected void after() {
        this.boundCluster.close();
    }

    @Override
    public Set<EndPoint> getContactPoints() {
        return ((BoundDataCenter)this.boundCluster.dc(0L)).getNodes().stream().map(node -> new DefaultEndPoint(node.inetSocketAddress())).collect(Collectors.toSet());
    }

    @Override
    public ProtocolVersion getHighestProtocolVersion() {
        return DefaultProtocolVersion.V4;
    }
}

