/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.ccm;

import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.testinfra.CassandraResourceRule;
import com.datastax.oss.driver.api.testinfra.ccm.CcmBridge;
import com.datastax.oss.driver.api.testinfra.requirement.BackendRequirementRule;
import com.datastax.oss.driver.api.testinfra.requirement.BackendType;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class BaseCcmRule
extends CassandraResourceRule {
    protected final CcmBridge ccmBridge;

    BaseCcmRule(CcmBridge ccmBridge) {
        this.ccmBridge = ccmBridge;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                ccmBridge.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    protected void before() {
        this.ccmBridge.create();
        this.ccmBridge.start();
    }

    protected void after() {
        this.ccmBridge.close();
    }

    public Statement apply(Statement base, final Description description) {
        if (BackendRequirementRule.meetsDescriptionRequirements(description)) {
            return super.apply(base, description);
        }
        return new Statement(){

            public void evaluate() {
                throw new AssumptionViolatedException(BackendRequirementRule.buildReasonString(description));
            }
        };
    }

    public BackendType getDistribution() {
        return CcmBridge.DISTRIBUTION;
    }

    public boolean isDistributionOf(BackendType type) {
        return CcmBridge.isDistributionOf(type);
    }

    public boolean isDistributionOf(BackendType type, CcmBridge.VersionComparator comparator) {
        return CcmBridge.isDistributionOf(type, comparator);
    }

    public Version getDistributionVersion() {
        return CcmBridge.getDistributionVersion();
    }

    public Version getCassandraVersion() {
        return CcmBridge.getCassandraVersion();
    }

    @Override
    public ProtocolVersion getHighestProtocolVersion() {
        if (CcmBridge.getCassandraVersion().compareTo(Version.V2_2_0) >= 0) {
            return DefaultProtocolVersion.V4;
        }
        return DefaultProtocolVersion.V3;
    }
}

