/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.springboot.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifierNamingStrategy;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerRouteEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerRouteEventNotifierNamingStrategy;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryFactory;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryNamingStrategy;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyFactory;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyNamingStrategy;
import org.apache.camel.component.micrometer.springboot.metrics.CamelMetricsConfiguration;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;

@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={CamelMetricsConfiguration.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
public class CamelMetricsAutoConfiguration {
    public CamelMetricsAutoConfiguration(CamelContext camelContext, CamelMetricsConfiguration configuration, MeterRegistry meterRegistry) {
        if (meterRegistry != null) {
            this.configureMicrometer(camelContext, configuration, meterRegistry);
        }
    }

    private void configureMicrometer(CamelContext camelContext, CamelMetricsConfiguration configuration, MeterRegistry meterRegistry) {
        MicrometerExchangeEventNotifier notifier;
        if (configuration.isEnableRoutePolicy()) {
            MicrometerRoutePolicyFactory factory = new MicrometerRoutePolicyFactory();
            factory.setCamelContext(camelContext);
            factory.setMeterRegistry(meterRegistry);
            if ("legacy".equalsIgnoreCase(configuration.getNamingStrategy())) {
                factory.setNamingStrategy(MicrometerRoutePolicyNamingStrategy.LEGACY);
            }
            if ("all".equalsIgnoreCase(configuration.getRoutePolicyLevel())) {
                factory.getPolicyConfiguration().setContextEnabled(true);
                factory.getPolicyConfiguration().setRouteEnabled(true);
            } else if ("context".equalsIgnoreCase(configuration.getRoutePolicyLevel())) {
                factory.getPolicyConfiguration().setContextEnabled(true);
                factory.getPolicyConfiguration().setRouteEnabled(false);
            } else {
                factory.getPolicyConfiguration().setContextEnabled(false);
                factory.getPolicyConfiguration().setRouteEnabled(true);
            }
            camelContext.addRoutePolicyFactory((RoutePolicyFactory)factory);
        }
        ManagementStrategy managementStrategy = camelContext.getManagementStrategy();
        if (configuration.isEnableExchangeEventNotifier()) {
            notifier = new MicrometerExchangeEventNotifier();
            notifier.setCamelContext(camelContext);
            notifier.setMeterRegistry(meterRegistry);
            if ("legacy".equalsIgnoreCase(configuration.getNamingStrategy())) {
                notifier.setNamingStrategy(MicrometerExchangeEventNotifierNamingStrategy.LEGACY);
            }
            managementStrategy.addEventNotifier((EventNotifier)notifier);
        }
        if (configuration.isEnableRouteEventNotifier()) {
            notifier = new MicrometerRouteEventNotifier();
            notifier.setCamelContext(camelContext);
            notifier.setMeterRegistry(meterRegistry);
            if ("legacy".equalsIgnoreCase(configuration.getNamingStrategy())) {
                notifier.setNamingStrategy(MicrometerRouteEventNotifierNamingStrategy.LEGACY);
            }
            managementStrategy.addEventNotifier((EventNotifier)notifier);
        }
        if (configuration.isEnableMessageHistory()) {
            if (!camelContext.isMessageHistory().booleanValue()) {
                camelContext.setMessageHistory(Boolean.valueOf(true));
            }
            MicrometerMessageHistoryFactory factory = new MicrometerMessageHistoryFactory();
            factory.setCamelContext(camelContext);
            factory.setMeterRegistry(meterRegistry);
            if ("legacy".equalsIgnoreCase(configuration.getNamingStrategy())) {
                factory.setNamingStrategy(MicrometerMessageHistoryNamingStrategy.LEGACY);
            }
            camelContext.setMessageHistoryFactory((MessageHistoryFactory)factory);
        }
    }
}

