/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.xpath;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.util.CastUtils;

public class DefaultNamespaceContext
implements NamespaceContext,
NamespaceAware {
    private final Map<String, String> map;
    private final NamespaceContext parent;

    public DefaultNamespaceContext() {
        this(XPathFactory.newInstance());
    }

    public DefaultNamespaceContext(XPathFactory factory) {
        this.parent = factory.newXPath().getNamespaceContext();
        this.map = new HashMap<String, String>();
    }

    public DefaultNamespaceContext(NamespaceContext parent, Map<String, String> map) {
        this.parent = parent;
        this.map = map;
    }

    public DefaultNamespaceContext add(String prefix, String uri) {
        this.map.put(prefix, uri);
        return this;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String answer = this.map.get(prefix);
        if (answer == null && this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        return answer;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (!namespaceURI.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        if (this.parent != null) {
            return this.parent.getPrefix(namespaceURI);
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (!namespaceURI.equals(entry.getValue())) continue;
            set.add(entry.getKey());
        }
        if (this.parent != null) {
            Iterator iter = CastUtils.cast(this.parent.getPrefixes(namespaceURI));
            while (iter.hasNext()) {
                set.add((String)iter.next());
            }
        }
        return set.iterator();
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.map.putAll(namespaces);
    }

    public Map<String, String> getNamespaces() {
        return this.map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[me: ");
        for (Map.Entry<String, String> nsEntry : this.map.entrySet()) {
            sb.append('{').append(nsEntry.getKey()).append(" -> ").append(nsEntry.getValue()).append("},");
        }
        if (!this.map.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        if (this.parent != null) {
            sb.append(", [parent: ");
            sb.append(this.parent.toString());
            sb.append("]");
        }
        return sb.toString();
    }
}

