/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.model.BasicExpressionNode;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.xml.out.ModelWriter;

@JdkService(value="modelxml-dumper")
public class LwModelToXMLDumper
implements ModelToXMLDumper {
    public String dumpModelAsXml(CamelContext context, NamedNode definition) throws Exception {
        return this.dumpModelAsXml(context, definition, false, true, false);
    }

    public String dumpModelAsXml(final CamelContext context, NamedNode definition, final boolean resolvePlaceholders, final boolean generatedIds, final boolean sourceLocation) throws Exception {
        final Properties properties = new Properties();
        final LinkedHashMap namespaces = new LinkedHashMap();
        HashMap locations = new HashMap();
        Consumer<RouteDefinition> extractor = route -> {
            Map parameters;
            LwModelToXMLDumper.extractNamespaces(route, namespaces);
            if (sourceLocation || context.isDebugging().booleanValue()) {
                LwModelToXMLDumper.extractSourceLocations(route, locations);
            }
            LwModelToXMLDumper.resolveEndpointDslUris(route);
            if (Boolean.TRUE.equals(route.isTemplate()) && (parameters = route.getTemplateParameters()) != null) {
                properties.putAll((Map<?, ?>)parameters);
            }
        };
        StringWriter buffer = new StringWriter();
        ModelWriter writer = new ModelWriter(buffer, "http://camel.apache.org/schema/xml-io"){

            @Override
            protected void doWriteOptionalIdentifiedDefinitionAttributes(OptionalIdentifiedDefinition<?> def) throws IOException {
                if (generatedIds || Boolean.TRUE.equals(def.getCustomId())) {
                    this.doWriteAttribute("id", def.getId());
                }
                if (def.getDescriptionText() != null) {
                    this.doWriteAttribute("description", def.getDescriptionText());
                }
                if (sourceLocation || context.isDebugging().booleanValue()) {
                    String loc = (def instanceof RouteDefinition ? ((RouteDefinition)def).getInput() : def).getLocation();
                    int line = (def instanceof RouteDefinition ? ((RouteDefinition)def).getInput() : def).getLineNumber();
                    if (line != -1) {
                        this.writer.addAttribute("sourceLineNumber", Integer.toString(line));
                        this.writer.addAttribute("sourceLocation", loc);
                    }
                }
            }

            @Override
            protected void startElement(String name) throws IOException {
                boolean namespaceWritten = this.namespaceWritten;
                super.startElement(name);
                if (!namespaceWritten) {
                    for (Map.Entry entry : namespaces.entrySet()) {
                        String nsPrefix = (String)entry.getKey();
                        Object prefix = nsPrefix.equals("xmlns") ? nsPrefix : "xmlns:" + nsPrefix;
                        this.writer.addAttribute((String)prefix, (String)entry.getValue());
                    }
                }
            }

            @Override
            protected void doWriteValue(String value) throws IOException {
                if (value != null && !value.isEmpty()) {
                    if (resolvePlaceholders) {
                        value = this.resolve(value, properties);
                    }
                    super.doWriteValue(value);
                }
            }

            @Override
            protected void text(String name, String text) throws IOException {
                if (resolvePlaceholders) {
                    text = this.resolve(text, properties);
                }
                super.text(name, text);
            }

            @Override
            protected void attribute(String name, Object value) throws IOException {
                if (resolvePlaceholders && value != null) {
                    value = this.resolve(value.toString(), properties);
                }
                super.attribute(name, value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            String resolve(String value, Properties properties2) {
                context.getPropertiesComponent().setLocalProperties(properties2);
                try {
                    String string = context.resolvePropertyPlaceholders(value);
                    return string;
                }
                catch (Exception e) {
                    String string = value;
                    return string;
                }
                finally {
                    context.getPropertiesComponent().setLocalProperties(null);
                }
            }
        };
        if (definition instanceof RouteTemplatesDefinition) {
            RouteTemplatesDefinition templates = (RouteTemplatesDefinition)definition;
            templates.getRouteTemplates().forEach(template -> extractor.accept(template.getRoute()));
        } else if (definition instanceof RouteTemplateDefinition) {
            RouteTemplateDefinition template2 = (RouteTemplateDefinition)definition;
            extractor.accept(template2.getRoute());
        } else if (definition instanceof RoutesDefinition) {
            RoutesDefinition routes = (RoutesDefinition)definition;
            routes.getRoutes().forEach(extractor);
        } else if (definition instanceof RouteDefinition) {
            RouteDefinition route2 = (RouteDefinition)definition;
            extractor.accept(route2);
        }
        writer.writeOptionalIdentifiedDefinitionRef((OptionalIdentifiedDefinition)definition);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpBeansAsXml(CamelContext context, List<Object> beans) throws Exception {
        StringWriter buffer = new StringWriter();
        BeanModelWriter writer = new BeanModelWriter(buffer);
        ArrayList list = new ArrayList();
        for (Object bean : beans) {
            if (!(bean instanceof BeanFactoryDefinition)) continue;
            BeanFactoryDefinition rb = (BeanFactoryDefinition)bean;
            list.add(rb);
        }
        writer.setCamelContext(context);
        writer.start();
        try {
            writer.writeBeans(list);
        }
        finally {
            writer.stop();
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpDataFormatsAsXml(CamelContext context, Map<String, Object> dataFormats) throws Exception {
        StringWriter buffer = new StringWriter();
        buffer.write("\n");
        DataFormatModelWriter writer = new DataFormatModelWriter(buffer);
        LinkedHashMap<String, DataFormatDefinition> map = new LinkedHashMap<String, DataFormatDefinition>();
        for (Map.Entry<String, Object> entry : dataFormats.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof DataFormatDefinition)) continue;
            DataFormatDefinition def = (DataFormatDefinition)object;
            map.put(entry.getKey(), def);
        }
        writer.setCamelContext(context);
        writer.start();
        try {
            writer.writeDataFormats(map);
        }
        finally {
            writer.stop();
        }
        return buffer.toString();
    }

    private static void extractNamespaces(RouteDefinition route, Map<String, String> namespaces) {
        Map map;
        NamespaceAware na;
        for (ExpressionNode en : ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), ExpressionNode.class)) {
            na = LwModelToXMLDumper.getNamespaceAwareFromExpression(en);
            if (na == null || (map = na.getNamespaces()) == null || map.isEmpty()) continue;
            namespaces.putAll(map);
        }
        for (ExpressionNode en : ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), BasicExpressionNode.class)) {
            na = LwModelToXMLDumper.getNamespaceAwareFromExpression((BasicExpressionNode)en);
            if (na == null || (map = na.getNamespaces()) == null || map.isEmpty()) continue;
            namespaces.putAll(map);
        }
    }

    private static void extractSourceLocations(RouteDefinition route, Map<String, KeyValueHolder<Integer, String>> locations) {
        String id = route.getRouteId();
        String loc = route.getInput().getLocation();
        int line = route.getInput().getLineNumber();
        if (id != null && line != -1) {
            locations.put(id, (KeyValueHolder<Integer, String>)new KeyValueHolder((Object)line, (Object)loc));
        }
        for (OptionalIdentifiedDefinition def : ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), OptionalIdentifiedDefinition.class)) {
            id = def.getId();
            loc = def.getLocation();
            line = def.getLineNumber();
            if (id == null || line == -1) continue;
            locations.put(id, (KeyValueHolder<Integer, String>)new KeyValueHolder((Object)line, (Object)loc));
        }
    }

    private static void resolveEndpointDslUris(RouteDefinition route) {
        FromDefinition from = route.getInput();
        if (from != null && from.getEndpointConsumerBuilder() != null) {
            String uri = from.getEndpointConsumerBuilder().getRawUri();
            from.setUri(uri);
        }
        Collection col = ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), SendDefinition.class);
        for (SendDefinition to : col) {
            if (to.getEndpointProducerBuilder() == null) continue;
            String uri = to.getEndpointProducerBuilder().getRawUri();
            to.setUri(uri);
        }
        Collection col2 = ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), ToDynamicDefinition.class);
        for (ToDynamicDefinition to : col2) {
            if (to.getEndpointProducerBuilder() == null) continue;
            String uri = to.getEndpointProducerBuilder().getRawUri();
            to.setUri(uri);
        }
    }

    private static NamespaceAware getNamespaceAwareFromExpression(ExpressionNode expressionNode) {
        ExpressionDefinition ed = expressionNode.getExpression();
        NamespaceAware na = null;
        Expression exp = ed.getExpressionValue();
        if (exp instanceof NamespaceAware) {
            NamespaceAware namespaceAware;
            na = namespaceAware = (NamespaceAware)exp;
        } else if (ed instanceof NamespaceAware) {
            NamespaceAware namespaceAware;
            na = namespaceAware = (NamespaceAware)ed;
        }
        return na;
    }

    private static NamespaceAware getNamespaceAwareFromExpression(BasicExpressionNode expressionNode) {
        ExpressionDefinition ed = expressionNode.getExpression();
        NamespaceAware na = null;
        Expression exp = ed.getExpressionValue();
        if (exp instanceof NamespaceAware) {
            NamespaceAware namespaceAware;
            na = namespaceAware = (NamespaceAware)exp;
        } else if (ed instanceof NamespaceAware) {
            NamespaceAware namespaceAware;
            na = namespaceAware = (NamespaceAware)ed;
        }
        return na;
    }

    private static class BeanModelWriter
    implements CamelContextAware {
        private final StringWriter buffer;
        private CamelContext camelContext;

        public BeanModelWriter(StringWriter buffer) {
            this.buffer = buffer;
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        public void start() {
        }

        public void stop() {
        }

        public void writeBeans(List<BeanFactoryDefinition<?>> beans) {
            if (beans.isEmpty()) {
                return;
            }
            for (BeanFactoryDefinition<?> b : beans) {
                this.doWriteBeanFactoryDefinition(b);
            }
        }

        private void doWriteBeanFactoryDefinition(BeanFactoryDefinition<?> b) {
            String type = b.getType();
            if (type.startsWith("#class:")) {
                type = type.substring(7);
            }
            this.buffer.write(String.format("    <bean name=\"%s\" type=\"%s\"", b.getName(), type));
            if (b.getFactoryBean() != null) {
                this.buffer.write(String.format(" factoryBean=\"%s\"", b.getFactoryBean()));
            }
            if (b.getFactoryMethod() != null) {
                this.buffer.write(String.format(" factoryMethod=\"%s\"", b.getFactoryMethod()));
            }
            if (b.getBuilderClass() != null) {
                this.buffer.write(String.format(" builderClass=\"%s\"", b.getBuilderClass()));
            }
            if (b.getBuilderMethod() != null) {
                this.buffer.write(String.format(" builderMethod=\"%s\"", b.getBuilderMethod()));
            }
            if (b.getInitMethod() != null) {
                this.buffer.write(String.format(" initMethod=\"%s\"", b.getInitMethod()));
            }
            if (b.getDestroyMethod() != null) {
                this.buffer.write(String.format(" destroyMethod=\"%s\"", b.getDestroyMethod()));
            }
            if (b.getScriptLanguage() != null) {
                this.buffer.write(String.format(" scriptLanguage=\"%s\"", b.getScriptLanguage()));
            }
            if (b.getScript() != null) {
                this.buffer.write(String.format("        <script>%n", new Object[0]));
                this.buffer.write(b.getScript());
                this.buffer.write("\n");
                this.buffer.write(String.format("        </script>%n", new Object[0]));
            }
            this.buffer.write(">\n");
            if (b.getConstructors() != null && !b.getConstructors().isEmpty()) {
                this.buffer.write(String.format("        <constructors>%n", new Object[0]));
                b.getConstructors().forEach((idx, value) -> {
                    if (idx != null) {
                        this.buffer.write(String.format("            <constructor index=\"%d\" value=\"%s\"/>%n", idx, value));
                    } else {
                        this.buffer.write(String.format("            <constructor value=\"%s\"/>%n", value));
                    }
                });
                this.buffer.write(String.format("        </constructors>%n", new Object[0]));
            }
            if (b.getProperties() != null && !b.getProperties().isEmpty()) {
                this.buffer.write(String.format("        <properties>%n", new Object[0]));
                b.getProperties().forEach((key, value) -> this.buffer.write(String.format("            <property key=\"%s\" value=\"%s\"/>%n", key, value)));
                this.buffer.write(String.format("        </properties>%n", new Object[0]));
            }
            this.buffer.write(String.format("    </bean>%n", new Object[0]));
        }
    }

    private static class DataFormatModelWriter
    implements CamelContextAware {
        private final StringWriter buffer;
        private CamelContext camelContext;

        public DataFormatModelWriter(StringWriter buffer) {
            this.buffer = buffer;
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        public void start() {
        }

        public void stop() {
        }

        public void writeDataFormats(Map<String, DataFormatDefinition> dataFormats) throws Exception {
            if (dataFormats.isEmpty()) {
                return;
            }
            DataFormatsDefinition def = new DataFormatsDefinition();
            def.setDataFormats(new ArrayList<DataFormatDefinition>(dataFormats.values()));
            StringWriter tmp = new StringWriter();
            ModelWriter writer = new ModelWriter(tmp, "http://camel.apache.org/schema/xml-io");
            writer.writeDataFormatsDefinition(def);
            for (String line : tmp.toString().split("\n")) {
                this.buffer.write("    ");
                this.buffer.write(line);
                this.buffer.write("\n");
            }
        }
    }
}

