/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.common;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.vertx.common.VertxBufferConverter;
import org.apache.camel.component.vertx.common.VertxJsonArrayConverter;
import org.apache.camel.component.vertx.common.VertxJsonObjectConverter;
import org.apache.camel.spi.BulkTypeConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.TypeConvertible;

@DeferredContextBinding
public final class CamelVertxCommonBulkConverterLoader
implements TypeConverterLoader,
BulkTypeConverters,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public int size() {
        return 30;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registry.addBulkTypeConverters((BulkTypeConverters)this);
        this.doRegistration(registry);
    }

    public <T> T convertTo(Class<?> from, Class<T> to, Exchange exchange, Object value) throws TypeConversionException {
        try {
            Object obj = this.doConvertTo(from, to, exchange, value);
            return (T)obj;
        }
        catch (TypeConversionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TypeConversionException(value, to, (Throwable)e);
        }
    }

    private Object doConvertTo(Class<?> from, Class<?> to, Exchange exchange, Object value) throws Exception {
        if (to == byte[].class) {
            if (value instanceof Buffer) {
                return VertxBufferConverter.toBytes((Buffer)value);
            }
            if (value instanceof JsonArray) {
                return VertxJsonArrayConverter.toBytes((JsonArray)value);
            }
            if (value instanceof JsonObject) {
                return VertxJsonObjectConverter.toBytes((JsonObject)value);
            }
        } else if (to == Buffer.class) {
            if (value instanceof byte[]) {
                return VertxBufferConverter.toBuffer((byte[])value);
            }
            if (value instanceof ByteBuf) {
                return VertxBufferConverter.toBuffer((ByteBuf)value);
            }
            if (value instanceof JsonArray) {
                return VertxJsonArrayConverter.toBuffer((JsonArray)value);
            }
            if (value instanceof JsonObject) {
                return VertxJsonObjectConverter.toBuffer((JsonObject)value);
            }
            if (value instanceof InputStream) {
                return VertxBufferConverter.toBuffer((InputStream)value);
            }
            if (value instanceof String) {
                return VertxBufferConverter.toBuffer((String)value, exchange);
            }
        } else if (to == JsonArray.class) {
            if (value instanceof byte[]) {
                return VertxJsonArrayConverter.toJsonArray((byte[])value);
            }
            if (value instanceof ByteBuf) {
                return VertxJsonArrayConverter.toJsonArray((ByteBuf)value);
            }
            if (value instanceof Buffer) {
                return VertxJsonArrayConverter.toJsonArray((Buffer)value);
            }
            if (value instanceof InputStream) {
                return VertxJsonArrayConverter.toJsonArray((InputStream)value);
            }
            if (value instanceof String) {
                return VertxJsonArrayConverter.toJsonArray((String)value);
            }
            if (value instanceof List) {
                return VertxJsonArrayConverter.toJsonArray((List)value);
            }
        } else if (to == JsonObject.class) {
            if (value instanceof byte[]) {
                return VertxJsonObjectConverter.toJsonObject((byte[])value);
            }
            if (value instanceof ByteBuf) {
                return VertxJsonObjectConverter.toJsonObject((ByteBuf)value);
            }
            if (value instanceof Buffer) {
                return VertxJsonObjectConverter.toJsonObject((Buffer)value);
            }
            if (value instanceof InputStream) {
                return VertxJsonObjectConverter.toJsonObject((InputStream)value);
            }
            if (value instanceof String) {
                return VertxJsonObjectConverter.toJsonObject((String)value);
            }
            if (value instanceof Map) {
                return VertxJsonObjectConverter.toJsonObject((Map)value);
            }
        } else if (to == InputStream.class) {
            if (value instanceof Buffer) {
                return VertxBufferConverter.toInputStream((Buffer)value);
            }
            if (value instanceof JsonArray) {
                return VertxJsonArrayConverter.toInputStream((JsonArray)value);
            }
            if (value instanceof JsonObject) {
                return VertxJsonObjectConverter.toInputStream((JsonObject)value);
            }
        } else if (to == String.class) {
            if (value instanceof Buffer) {
                return VertxBufferConverter.toString((Buffer)value, exchange);
            }
            if (value instanceof JsonArray) {
                return VertxJsonArrayConverter.toString((JsonArray)value);
            }
            if (value instanceof JsonObject) {
                return VertxJsonObjectConverter.toString((JsonObject)value);
            }
        } else if (to == List.class) {
            if (value instanceof JsonArray) {
                return VertxJsonArrayConverter.toList((JsonArray)value);
            }
        } else if (to == Map.class) {
            if (value instanceof JsonObject) {
                return VertxJsonObjectConverter.toMap((JsonObject)value);
            }
        } else if (to == StreamCache.class && value instanceof Buffer) {
            return VertxBufferConverter.toStreamCache((Buffer)value);
        }
        return null;
    }

    private void doRegistration(TypeConverterRegistry registry) {
        registry.addConverter(new TypeConvertible(Buffer.class, byte[].class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(JsonArray.class, byte[].class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(JsonObject.class, byte[].class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(byte[].class, Buffer.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(ByteBuf.class, Buffer.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(JsonArray.class, Buffer.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(JsonObject.class, Buffer.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(InputStream.class, Buffer.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(String.class, Buffer.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(byte[].class, JsonArray.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(ByteBuf.class, JsonArray.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Buffer.class, JsonArray.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(InputStream.class, JsonArray.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(String.class, JsonArray.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(List.class, JsonArray.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(byte[].class, JsonObject.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(ByteBuf.class, JsonObject.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Buffer.class, JsonObject.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(InputStream.class, JsonObject.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(String.class, JsonObject.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Map.class, JsonObject.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Buffer.class, InputStream.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(JsonArray.class, InputStream.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(JsonObject.class, InputStream.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Buffer.class, String.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(JsonArray.class, String.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(JsonObject.class, String.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(JsonArray.class, List.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(JsonObject.class, Map.class), (TypeConverter)this);
        registry.addConverter(new TypeConvertible(Buffer.class, StreamCache.class), (TypeConverter)this);
    }

    public TypeConverter lookup(Class<?> to, Class<?> from) {
        if (to == byte[].class) {
            if (from == Buffer.class) {
                return this;
            }
            if (from == JsonArray.class) {
                return this;
            }
            if (from == JsonObject.class) {
                return this;
            }
        } else if (to == Buffer.class) {
            if (from == byte[].class) {
                return this;
            }
            if (from == ByteBuf.class) {
                return this;
            }
            if (from == JsonArray.class) {
                return this;
            }
            if (from == JsonObject.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
        } else if (to == JsonArray.class) {
            if (from == byte[].class) {
                return this;
            }
            if (from == ByteBuf.class) {
                return this;
            }
            if (from == Buffer.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
            if (from == List.class) {
                return this;
            }
        } else if (to == JsonObject.class) {
            if (from == byte[].class) {
                return this;
            }
            if (from == ByteBuf.class) {
                return this;
            }
            if (from == Buffer.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
            if (from == Map.class) {
                return this;
            }
        } else if (to == InputStream.class) {
            if (from == Buffer.class) {
                return this;
            }
            if (from == JsonArray.class) {
                return this;
            }
            if (from == JsonObject.class) {
                return this;
            }
        } else if (to == String.class) {
            if (from == Buffer.class) {
                return this;
            }
            if (from == JsonArray.class) {
                return this;
            }
            if (from == JsonObject.class) {
                return this;
            }
        } else if (to == List.class ? from == JsonArray.class : (to == Map.class ? from == JsonObject.class : to == StreamCache.class && from == Buffer.class)) {
            return this;
        }
        return null;
    }
}

