/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.BitSet;
import java.util.List;
import org.apache.camel.util.Pair;
import org.apache.camel.util.URISupport;

public final class UnsafeUriCharactersEncoder {
    private static final BitSet unsafeCharactersFastParser;
    private static final BitSet unsafeCharactersRfc1738;
    private static final BitSet unsafeCharactersHttp;
    private static final char[] HEX_DIGITS;

    private UnsafeUriCharactersEncoder() {
    }

    public static boolean isSafeFastParser(char ch) {
        return !unsafeCharactersFastParser.get(ch);
    }

    public static String encode(String s) {
        return UnsafeUriCharactersEncoder.encode(s, unsafeCharactersRfc1738);
    }

    public static String encodeHttpURI(String s) {
        return UnsafeUriCharactersEncoder.encode(s, unsafeCharactersHttp);
    }

    public static String encode(String s, BitSet unsafeCharacters) {
        return UnsafeUriCharactersEncoder.encode(s, unsafeCharacters, false);
    }

    public static String encode(String s, boolean checkRaw) {
        return UnsafeUriCharactersEncoder.encode(s, unsafeCharactersRfc1738, checkRaw);
    }

    public static String encodeHttpURI(String s, boolean checkRaw) {
        return UnsafeUriCharactersEncoder.encode(s, unsafeCharactersHttp, checkRaw);
    }

    public static String encode(String s, BitSet unsafeCharacters, boolean checkRaw) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return s;
        }
        boolean safe = true;
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch <= '\u0000' || ch >= '\u0080' || !unsafeCharacters.get(ch)) continue;
            safe = false;
            break;
        }
        if (safe) {
            return s;
        }
        List<Pair<Integer>> rawPairs = null;
        if (checkRaw) {
            rawPairs = URISupport.scanRaw(s);
        }
        int initial = len + 8;
        StringBuilder sb = new StringBuilder(initial);
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch > '\u0000' && ch < '\u0080' && unsafeCharacters.get(ch)) {
                if (ch == '%') {
                    char next2;
                    char next = i + 1 < len ? (char)s.charAt(i + 1) : (char)' ';
                    char c = next2 = i + 2 < len ? (char)s.charAt(i + 2) : (char)' ';
                    if (UnsafeUriCharactersEncoder.isHexDigit(next) && UnsafeUriCharactersEncoder.isHexDigit(next2) && !URISupport.isRaw(i, rawPairs)) {
                        sb.append(ch);
                        continue;
                    }
                    UnsafeUriCharactersEncoder.appendEscape(sb, (byte)ch);
                    continue;
                }
                UnsafeUriCharactersEncoder.appendEscape(sb, (byte)ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static void appendEscape(StringBuilder sb, byte b) {
        sb.append('%');
        sb.append(HEX_DIGITS[b >> 4 & 0xF]);
        sb.append(HEX_DIGITS[b >> 0 & 0xF]);
    }

    private static boolean isHexDigit(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    static {
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'a', 'b', 'c', 'd', 'e', 'f'};
        unsafeCharactersFastParser = new BitSet(14);
        unsafeCharactersFastParser.set(32);
        unsafeCharactersFastParser.set(34);
        unsafeCharactersFastParser.set(60);
        unsafeCharactersFastParser.set(62);
        unsafeCharactersFastParser.set(37);
        unsafeCharactersFastParser.set(123);
        unsafeCharactersFastParser.set(125);
        unsafeCharactersFastParser.set(124);
        unsafeCharactersFastParser.set(92);
        unsafeCharactersFastParser.set(94);
        unsafeCharactersFastParser.set(126);
        unsafeCharactersFastParser.set(91);
        unsafeCharactersFastParser.set(93);
        unsafeCharactersFastParser.set(96);
        unsafeCharactersRfc1738 = new BitSet(15);
        unsafeCharactersRfc1738.set(32);
        unsafeCharactersRfc1738.set(34);
        unsafeCharactersRfc1738.set(60);
        unsafeCharactersRfc1738.set(62);
        unsafeCharactersRfc1738.set(35);
        unsafeCharactersRfc1738.set(37);
        unsafeCharactersRfc1738.set(123);
        unsafeCharactersRfc1738.set(125);
        unsafeCharactersRfc1738.set(124);
        unsafeCharactersRfc1738.set(92);
        unsafeCharactersRfc1738.set(94);
        unsafeCharactersRfc1738.set(126);
        unsafeCharactersRfc1738.set(91);
        unsafeCharactersRfc1738.set(93);
        unsafeCharactersRfc1738.set(96);
        unsafeCharactersHttp = new BitSet(13);
        unsafeCharactersHttp.set(32);
        unsafeCharactersHttp.set(34);
        unsafeCharactersHttp.set(60);
        unsafeCharactersHttp.set(62);
        unsafeCharactersHttp.set(35);
        unsafeCharactersHttp.set(37);
        unsafeCharactersHttp.set(123);
        unsafeCharactersHttp.set(125);
        unsafeCharactersHttp.set(124);
        unsafeCharactersHttp.set(92);
        unsafeCharactersHttp.set(94);
        unsafeCharactersHttp.set(126);
        unsafeCharactersHttp.set(96);
    }
}

