/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TimeUtils.class);
    private static final Pattern NUMBERS_ONLY_STRING_PATTERN = Pattern.compile("^[-]?(\\d)+$", 2);
    private static final Pattern HOUR_REGEX_PATTERN = Pattern.compile("((\\d)*(\\d))h(our(s)?)?", 2);
    private static final Pattern MINUTES_REGEX_PATTERN = Pattern.compile("((\\d)*(\\d))m(in(ute(s)?)?)?", 2);
    private static final Pattern SECONDS_REGEX_PATTERN = Pattern.compile("((\\d)*(\\d))s(ec(ond)?(s)?)?", 2);

    private TimeUtils() {
    }

    public static String printDuration(double uptime) {
        DecimalFormat fmtI = new DecimalFormat("###,###", new DecimalFormatSymbols(Locale.ENGLISH));
        DecimalFormat fmtD = new DecimalFormat("###,##0.000", new DecimalFormatSymbols(Locale.ENGLISH));
        if ((uptime /= 1000.0) < 60.0) {
            return fmtD.format(uptime) + " seconds";
        }
        if ((uptime /= 60.0) < 60.0) {
            long minutes = (long)uptime;
            String s = fmtI.format(minutes) + (minutes > 1L ? " minutes" : " minute");
            return s;
        }
        if ((uptime /= 60.0) < 24.0) {
            long hours = (long)uptime;
            long minutes = (long)((uptime - (double)hours) * 60.0);
            String s = fmtI.format(hours) + (hours > 1L ? " hours" : " hour");
            if (minutes != 0L) {
                s = s + " " + fmtI.format(minutes) + (minutes > 1L ? " minutes" : " minute");
            }
            return s;
        }
        long days = (long)(uptime /= 24.0);
        long hours = (long)((uptime - (double)days) * 24.0);
        String s = fmtI.format(days) + (days > 1L ? " days" : " day");
        if (hours != 0L) {
            s = s + " " + fmtI.format(hours) + (hours > 1L ? " hours" : " hour");
        }
        return s;
    }

    public static long toMilliSeconds(String source) throws IllegalArgumentException {
        boolean digit = true;
        for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            if (i == 0 && ch == '-' || ch >= '0' && ch <= '9') continue;
            digit = false;
            break;
        }
        if (digit) {
            return Long.valueOf(source);
        }
        long milliseconds = 0L;
        boolean foundFlag = false;
        TimeUtils.checkCorrectnessOfPattern(source);
        Matcher matcher = TimeUtils.createMatcher(NUMBERS_ONLY_STRING_PATTERN, source);
        if (matcher.find()) {
            milliseconds = Long.valueOf(source);
        } else {
            matcher = TimeUtils.createMatcher(HOUR_REGEX_PATTERN, source);
            if (matcher.find()) {
                milliseconds += 3600000L * Long.valueOf(matcher.group(1));
                foundFlag = true;
            }
            if ((matcher = TimeUtils.createMatcher(MINUTES_REGEX_PATTERN, source)).find()) {
                long minutes = Long.valueOf(matcher.group(1));
                if (minutes > 59L && foundFlag) {
                    throw new IllegalArgumentException("Minutes should contain a valid value between 0 and 59: " + source);
                }
                foundFlag = true;
                milliseconds += 60000L * minutes;
            }
            if ((matcher = TimeUtils.createMatcher(SECONDS_REGEX_PATTERN, source)).find()) {
                long seconds = Long.valueOf(matcher.group(1));
                if (seconds > 59L && foundFlag) {
                    throw new IllegalArgumentException("Seconds should contain a valid value between 0 and 59: " + source);
                }
                foundFlag = true;
                milliseconds += 1000L * seconds;
            }
            if (!foundFlag) {
                milliseconds = Long.valueOf(source);
            }
        }
        LOG.trace("source: {} milliseconds: ", (Object)source, (Object)milliseconds);
        return milliseconds;
    }

    private static void checkCorrectnessOfPattern(String source) {
        Matcher matcher = TimeUtils.createMatcher(NUMBERS_ONLY_STRING_PATTERN, source);
        String replaceSource = matcher.replaceFirst("");
        if ((matcher = TimeUtils.createMatcher(HOUR_REGEX_PATTERN, replaceSource)).find() && matcher.find()) {
            throw new IllegalArgumentException("Hours should not be specified more then once: " + source);
        }
        replaceSource = matcher.replaceFirst("");
        if ((matcher = TimeUtils.createMatcher(MINUTES_REGEX_PATTERN, replaceSource)).find() && matcher.find()) {
            throw new IllegalArgumentException("Minutes should not be specified more then once: " + source);
        }
        replaceSource = matcher.replaceFirst("");
        if ((matcher = TimeUtils.createMatcher(SECONDS_REGEX_PATTERN, replaceSource)).find() && matcher.find()) {
            throw new IllegalArgumentException("Seconds should not be specified more then once: " + source);
        }
        replaceSource = matcher.replaceFirst("");
        if (replaceSource.length() > 0) {
            throw new IllegalArgumentException("Illegal characters: " + source);
        }
    }

    private static Matcher createMatcher(Pattern pattern, String source) {
        return pattern.matcher(source);
    }
}

