/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.model;

import java.util.List;
import org.apache.camel.tooling.model.Strings;

public abstract class BaseOptionModel {
    protected String name;
    protected String kind;
    protected String displayName;
    protected String group;
    protected String label;
    protected boolean required;
    protected String type;
    protected String javaType;
    protected List<String> enums;
    protected List<String> oneOfs;
    protected String prefix;
    protected String optionalPrefix;
    protected boolean multiValue;
    protected boolean deprecated;
    protected String deprecationNote;
    protected boolean secret;
    protected boolean autowired;
    protected Object defaultValue;
    protected String defaultValueNote;
    protected boolean asPredicate;
    protected String setterMethod;
    protected String getterMethod;
    protected String configurationClass;
    protected String configurationField;
    protected String description;
    protected String nestedType;
    protected boolean newGroup;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public List<String> getEnums() {
        return this.enums;
    }

    public void setEnums(List<String> enums) {
        this.enums = enums;
    }

    public List<String> getOneOfs() {
        return this.oneOfs;
    }

    public void setOneOfs(List<String> oneOfs) {
        this.oneOfs = oneOfs;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getOptionalPrefix() {
        return this.optionalPrefix;
    }

    public void setOptionalPrefix(String optionalPrefix) {
        this.optionalPrefix = optionalPrefix;
    }

    public boolean isMultiValue() {
        return this.multiValue;
    }

    public void setMultiValue(boolean multiValue) {
        this.multiValue = multiValue;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getDeprecationNote() {
        return this.deprecationNote;
    }

    public void setDeprecationNote(String deprecationNote) {
        this.deprecationNote = deprecationNote;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public void setSecret(boolean secret) {
        this.secret = secret;
    }

    public boolean isAutowired() {
        return this.autowired;
    }

    public void setAutowired(boolean autowired) {
        this.autowired = autowired;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValueNote() {
        return this.defaultValueNote;
    }

    public void setDefaultValueNote(String defaultValueNote) {
        this.defaultValueNote = defaultValueNote;
    }

    public boolean isAsPredicate() {
        return this.asPredicate;
    }

    public void setAsPredicate(boolean asPredicate) {
        this.asPredicate = asPredicate;
    }

    public String getSetterMethod() {
        return this.setterMethod;
    }

    public void setSetterMethod(String setterMethod) {
        this.setterMethod = setterMethod;
    }

    public String getGetterMethod() {
        return this.getterMethod;
    }

    public void setGetterMethod(String getterMethod) {
        this.getterMethod = getterMethod;
    }

    public String getConfigurationClass() {
        return this.configurationClass;
    }

    public void setConfigurationClass(String configurationClass) {
        this.configurationClass = configurationClass;
    }

    public String getConfigurationField() {
        return this.configurationField;
    }

    public void setConfigurationField(String configurationField) {
        this.configurationField = configurationField;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isNewGroup() {
        return this.newGroup;
    }

    public void setNewGroup(boolean newGroup) {
        this.newGroup = newGroup;
    }

    public String getNestedType() {
        return this.nestedType;
    }

    public void setNestedType(String nestedType) {
        this.nestedType = nestedType;
    }

    public String getShortGroup() {
        if (this.group != null && this.group.endsWith(" (advanced)")) {
            return this.group.substring(0, this.group.length() - 11);
        }
        return this.group;
    }

    public String getShortJavaType() {
        return Strings.getClassShortName(this.javaType);
    }

    @Deprecated
    public String getShortJavaType(int watermark) {
        String text = Strings.getClassShortName(this.type);
        if ("object".equals(this.type)) {
            text = Strings.wrapCamelCaseWords(text, watermark, " ");
        }
        return text;
    }

    public String getShortDefaultValue(int watermark) {
        String text;
        String string = text = this.defaultValue != null ? this.defaultValue.toString() : "";
        if (text.endsWith("<T>")) {
            text = text.substring(0, text.length() - 3);
        } else if (text.endsWith("<T>>")) {
            text = text.substring(0, text.length() - 4);
        }
        return text;
    }

    public String getShortName(int watermark) {
        String text = Strings.wrapCamelCaseWords(this.name, watermark, "{zwsp}");
        return Character.toLowerCase(text.charAt(0)) + text.substring(1);
    }
}

