/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.StartupListener;
import org.apache.camel.Suspendable;
import org.apache.camel.component.timer.TimerEndpoint;
import org.apache.camel.support.DefaultConsumer;

public class TimerConsumer
extends DefaultConsumer
implements StartupListener,
Suspendable {
    private final TimerEndpoint endpoint;
    private volatile TimerTask task;
    private volatile boolean configured;
    private ExecutorService executorService;

    public TimerConsumer(TimerEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public TimerEndpoint getEndpoint() {
        return (TimerEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.endpoint.getDelay() >= 0L) {
            this.task = new TimerTask(){
                private final AtomicLong counter = new AtomicLong();

                @Override
                public void run() {
                    if (!TimerConsumer.this.isTaskRunAllowed()) {
                        TimerConsumer.this.log.debug("Run not allowed for timer: {}", (Object)TimerConsumer.this.endpoint);
                        return;
                    }
                    try {
                        boolean fire;
                        long count = this.counter.incrementAndGet();
                        boolean bl = fire = TimerConsumer.this.endpoint.getRepeatCount() <= 0L || count <= TimerConsumer.this.endpoint.getRepeatCount();
                        if (fire) {
                            TimerConsumer.this.sendTimerExchange(count);
                        } else {
                            TimerConsumer.this.log.debug("Cancelling {} timer as repeat count limit reached after {} counts.", (Object)TimerConsumer.this.endpoint.getTimerName(), (Object)TimerConsumer.this.endpoint.getRepeatCount());
                            this.cancel();
                        }
                    }
                    catch (Throwable e) {
                        TimerConsumer.this.log.warn("Error processing exchange. This exception will be ignored, to let the timer be able to trigger again.", e);
                    }
                }
            };
            if (!this.configured && this.endpoint.getCamelContext().getStatus().isStarted()) {
                Timer timer = this.endpoint.getTimer(this);
                this.configureTask(this.task, timer);
            }
        } else {
            this.executorService = this.endpoint.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, this.endpoint.getEndpointUri());
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    AtomicLong counter = new AtomicLong();
                    long count = counter.incrementAndGet();
                    while ((TimerConsumer.this.endpoint.getRepeatCount() <= 0L || count <= TimerConsumer.this.endpoint.getRepeatCount()) && TimerConsumer.this.isRunAllowed()) {
                        TimerConsumer.this.sendTimerExchange(count);
                        count = counter.incrementAndGet();
                    }
                }
            });
        }
    }

    protected void doStop() throws Exception {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = null;
        this.configured = false;
        this.endpoint.removeTimer(this);
        if (this.executorService != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.executorService);
            this.executorService = null;
        }
        super.doStop();
    }

    public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        if (this.task != null && !this.configured) {
            Timer timer = this.endpoint.getTimer(this);
            this.configureTask(this.task, timer);
        }
    }

    protected boolean isTaskRunAllowed() {
        return this.endpoint.getCamelContext().getStatus().isStarted() && this.isRunAllowed() && !this.isSuspended();
    }

    protected void configureTask(TimerTask task, Timer timer) {
        if (this.endpoint.isFixedRate()) {
            if (this.endpoint.getTime() != null) {
                timer.scheduleAtFixedRate(task, this.endpoint.getTime(), this.endpoint.getPeriod());
            } else {
                timer.scheduleAtFixedRate(task, this.endpoint.getDelay(), this.endpoint.getPeriod());
            }
        } else if (this.endpoint.getTime() != null) {
            if (this.endpoint.getPeriod() > 0L) {
                timer.schedule(task, this.endpoint.getTime(), this.endpoint.getPeriod());
            } else {
                timer.schedule(task, this.endpoint.getTime());
            }
        } else if (this.endpoint.getPeriod() > 0L) {
            timer.schedule(task, this.endpoint.getDelay(), this.endpoint.getPeriod());
        } else {
            timer.schedule(task, this.endpoint.getDelay());
        }
        this.configured = true;
    }

    protected void sendTimerExchange(long counter) {
        final Exchange exchange = this.endpoint.createExchange();
        exchange.setProperty("CamelTimerCounter", (Object)counter);
        exchange.setProperty("CamelTimerName", (Object)this.endpoint.getTimerName());
        exchange.setProperty("CamelTimerTime", (Object)this.endpoint.getTime());
        exchange.setProperty("CamelTimerPeriod", (Object)this.endpoint.getPeriod());
        Date now = new Date();
        exchange.setProperty("CamelTimerFiredTime", (Object)now);
        exchange.getIn().setHeader("firedTime", (Object)now);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Timer {} is firing #{} count", (Object)this.endpoint.getTimerName(), (Object)counter);
        }
        if (!this.endpoint.isSynchronous()) {
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    if (exchange.getException() != null) {
                        TimerConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                    }
                }
            });
        } else {
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }
}

