/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5;

import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.test.junit5.CamelContextConfiguration;
import org.apache.camel.test.junit5.CamelContextManager;
import org.apache.camel.test.junit5.ContextManagerFactory;
import org.apache.camel.test.junit5.TestExecutionConfiguration;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextManagerExtension
implements BeforeEachCallback,
AfterEachCallback,
AfterAllCallback,
BeforeAllCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ContextManagerExtension.class);
    private final TestExecutionConfiguration testConfigurationBuilder;
    private final CamelContextConfiguration camelContextConfiguration;
    private CamelContextManager contextManager;
    private final ContextManagerFactory contextManagerFactory;
    private String currentTestName;

    public ContextManagerExtension() {
        this(new ContextManagerFactory());
    }

    public ContextManagerExtension(ContextManagerFactory contextManagerFactory) {
        this.testConfigurationBuilder = new TestExecutionConfiguration();
        this.camelContextConfiguration = new CamelContextConfiguration();
        this.contextManagerFactory = contextManagerFactory;
    }

    public ContextManagerExtension(TestExecutionConfiguration testConfigurationBuilder, CamelContextConfiguration camelContextConfiguration) {
        this.testConfigurationBuilder = testConfigurationBuilder;
        this.camelContextConfiguration = camelContextConfiguration;
        this.contextManagerFactory = new ContextManagerFactory();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        boolean perClassPresent = context.getTestInstanceLifecycle().filter(lc -> lc.equals((Object)TestInstance.Lifecycle.PER_CLASS)).isPresent();
        if (perClassPresent) {
            LOG.warn("Creating a legacy context manager for {}. This function is deprecated and will be removed in the future", (Object)context.getDisplayName());
            this.contextManager = this.contextManagerFactory.createContextManager(ContextManagerFactory.Type.BEFORE_ALL, this.testConfigurationBuilder, this.camelContextConfiguration);
            ExtensionContext.Store globalStore = context.getStore(ExtensionContext.Namespace.GLOBAL);
            this.contextManager.setGlobalStore(globalStore);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.contextManager.stop();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.contextManager == null) {
            LOG.trace("Creating a transient context manager for {}", (Object)context.getDisplayName());
            this.contextManager = this.contextManagerFactory.createContextManager(ContextManagerFactory.Type.BEFORE_EACH, this.testConfigurationBuilder, this.camelContextConfiguration);
        }
        this.currentTestName = context.getDisplayName();
        ExtensionContext.Store globalStore = context.getStore(ExtensionContext.Namespace.GLOBAL);
        this.contextManager.setGlobalStore(globalStore);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        DefaultCamelContext.clearOptions();
        this.contextManager.stop();
    }

    public CamelContextManager getContextManager() {
        return this.contextManager;
    }

    public String getCurrentTestName() {
        return this.currentTestName;
    }

    public TestExecutionConfiguration getTestConfigurationBuilder() {
        return this.testConfigurationBuilder;
    }

    public CamelContextConfiguration getCamelContextConfiguration() {
        return this.camelContextConfiguration;
    }
}

