/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Service;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.test.junit5.CamelContextConfiguration;
import org.apache.camel.test.junit5.CommonTestSupport;
import org.apache.camel.test.junit5.TestExecutionConfiguration;

public abstract class AbstractTestSupport
implements CommonTestSupport {
    protected final TestExecutionConfiguration testConfigurationBuilder;
    protected final CamelContextConfiguration camelContextConfiguration;
    protected volatile ModelCamelContext context;
    protected volatile ProducerTemplate template;
    protected volatile FluentProducerTemplate fluentTemplate;
    protected volatile ConsumerTemplate consumer;

    protected AbstractTestSupport() {
        this.testConfigurationBuilder = new TestExecutionConfiguration();
        this.camelContextConfiguration = new CamelContextConfiguration();
    }

    protected AbstractTestSupport(TestExecutionConfiguration testConfigurationBuilder, CamelContextConfiguration camelContextConfiguration) {
        this.testConfigurationBuilder = testConfigurationBuilder;
        this.camelContextConfiguration = camelContextConfiguration;
    }

    protected void setupResources() throws Exception {
    }

    protected void cleanupResources() throws Exception {
    }

    @Deprecated(since="4.7.0")
    public boolean isUseRouteBuilder() {
        return this.testConfigurationBuilder.useRouteBuilder();
    }

    @Deprecated(since="4.7.0")
    public void setUseRouteBuilder(boolean useRouteBuilder) {
        this.testConfigurationBuilder.withUseRouteBuilder(useRouteBuilder);
    }

    @Deprecated(since="4.7.0")
    public boolean isDumpRouteCoverage() {
        return this.testConfigurationBuilder.isDumpRouteCoverage();
    }

    @Deprecated(since="4.7.0")
    public boolean isUseAdviceWith() {
        return this.testConfigurationBuilder.isUseAdviceWith();
    }

    @Deprecated(since="4.7.0")
    protected final boolean isCreateCamelContextPerClass() {
        return this.testConfigurationBuilder.isCreateCamelContextPerClass();
    }

    @Deprecated(since="4.7.0")
    public String isMockEndpoints() {
        return this.camelContextConfiguration().mockEndpoints();
    }

    @Deprecated(since="4.7.0")
    public String isMockEndpointsAndSkip() {
        return this.camelContextConfiguration().mockEndpointsAndSkip();
    }

    @Deprecated(since="4.7.0")
    public void replaceRouteFromWith(String routeId, String fromEndpoint) {
        this.camelContextConfiguration.replaceRouteFromWith(routeId, fromEndpoint);
    }

    @Deprecated(since="4.7.0")
    public String getRouteFilterIncludePattern() {
        return this.camelContextConfiguration.routeFilterIncludePattern();
    }

    @Deprecated(since="4.7.0")
    public String getRouteFilterExcludePattern() {
        return this.camelContextConfiguration.routeFilterExcludePattern();
    }

    @Deprecated(since="4.7.0")
    public boolean isUseDebugger() {
        return this.camelContextConfiguration.useDebugger();
    }

    @Deprecated(since="4.7.0")
    public Service getCamelContextService() {
        return this.camelContextConfiguration.camelContextService();
    }

    @Deprecated(since="4.7.0")
    public Service camelContextService() {
        return this.camelContextConfiguration.camelContextService();
    }

    public CamelContext context() {
        return this.context;
    }

    @Deprecated(since="4.7.0")
    public void setContext(ModelCamelContext context) {
        this.context = context;
    }

    public ProducerTemplate template() {
        return this.template;
    }

    public FluentProducerTemplate fluentTemplate() {
        return this.fluentTemplate;
    }

    public ConsumerTemplate consumer() {
        return this.consumer;
    }

    public void setCamelContextService(Service service) {
        this.camelContextConfiguration.withCamelContextService(service);
    }

    @Deprecated(since="4.7.0")
    protected boolean useJmx() {
        return this.testConfigurationBuilder.isJmxEnabled();
    }

    @Deprecated(since="4.7.0")
    protected Properties useOverridePropertiesWithPropertiesComponent() {
        return this.camelContextConfiguration.useOverridePropertiesWithPropertiesComponent();
    }

    @Deprecated(since="4.7.0")
    protected Boolean ignoreMissingLocationWithPropertiesComponent() {
        return this.camelContextConfiguration.ignoreMissingLocationWithPropertiesComponent();
    }

    @Override
    public final CamelContextConfiguration camelContextConfiguration() {
        return this.camelContextConfiguration;
    }

    @Override
    public final TestExecutionConfiguration testConfiguration() {
        return this.testConfigurationBuilder;
    }

    @Deprecated(since="4.7.0")
    protected void disableJMX() {
        this.testConfigurationBuilder.withDisableJMX();
    }

    @Deprecated(since="4.7.0")
    protected void enableJMX() {
        this.testConfigurationBuilder.withEnableJMX();
    }

    @Deprecated(since="4.7.0")
    protected boolean isRouteCoverageEnabled() {
        return this.testConfigurationBuilder.isRouteCoverageEnabled();
    }
}

