/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5.params;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.test.junit5.params.Parameter;
import org.apache.camel.test.junit5.params.Parameters;
import org.apache.camel.test.junit5.params.Test;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.params.converter.DefaultArgumentConverter;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.ReflectionUtils;

public class ParameterizedExtension
implements TestTemplateInvocationContextProvider {
    public boolean supportsTestTemplate(ExtensionContext context) {
        return context.getTestMethod().map(m -> AnnotationUtils.isAnnotated((AnnotatedElement)m, Test.class)).orElse(false);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        Class testClass = extensionContext.getRequiredTestClass();
        try {
            List<Method> parameters = this.getParametersMethods(testClass);
            if (parameters.size() != 1) {
                throw new IllegalStateException("Class " + testClass.getName() + " should provide a single method annotated with @" + Parameters.class.getSimpleName());
            }
            Object params = parameters.iterator().next().invoke(null, new Object[0]);
            return CollectionUtils.toStream((Object)params).map(ParameterizedExtension::toArguments).map(Arguments::get).map(ParameterizedTemplate::new);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to generate test templates for class " + testClass.getName(), e);
        }
    }

    private List<Method> getParametersMethods(Class<?> testClass) {
        List<Method> parameters = Stream.of(testClass.getDeclaredMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.getAnnotation(Parameters.class) != null).collect(Collectors.toList());
        if (parameters.isEmpty() && testClass != null) {
            return this.getParametersMethods(testClass.getSuperclass());
        }
        return parameters;
    }

    private static Arguments toArguments(Object item) {
        if (item instanceof Arguments) {
            return (Arguments)item;
        }
        if (ReflectionUtils.isMultidimensionalArray((Object)item)) {
            return Arguments.arguments((Object[])new Object[]{item});
        }
        if (item instanceof Object[]) {
            return Arguments.arguments((Object[])((Object[])item));
        }
        return Arguments.arguments((Object[])new Object[]{item});
    }

    public static class ParameterizedTemplate
    implements TestTemplateInvocationContext {
        private final Object[] params;

        public ParameterizedTemplate(Object[] params) {
            this.params = params;
        }

        public String getDisplayName(int invocationIndex) {
            return "[" + invocationIndex + "] " + Stream.of(this.params).map(Object::toString).collect(Collectors.joining(", "));
        }

        public List<Extension> getAdditionalExtensions() {
            return Arrays.asList(this::postProcessTestInstance);
        }

        protected void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
            Class<?> clazz = testInstance.getClass();
            List fields = this.hierarchy(clazz).map(Class::getDeclaredFields).flatMap(Stream::of).filter(f -> AnnotationUtils.isAnnotated((AnnotatedElement)f, Parameter.class)).sorted(Comparator.comparing(f -> f.getAnnotation(Parameter.class).value())).collect(Collectors.toList());
            if (this.params.length != fields.size()) {
                throw new TestInstantiationException("Expected " + fields.size() + " parameters bug got " + this.params.length + " when instantiating " + clazz.getName());
            }
            for (int i = 0; i < fields.size(); ++i) {
                Field f2 = (Field)fields.get(i);
                f2.setAccessible(true);
                f2.set(testInstance, DefaultArgumentConverter.INSTANCE.convert(this.params[i], f2.getType()));
            }
        }

        protected Stream<Class<?>> hierarchy(Class<?> clazz) {
            Class<?> superclass = clazz.getSuperclass();
            return Stream.concat(Stream.of(clazz), superclass != null ? this.hierarchy(superclass) : Stream.empty());
        }
    }
}

