/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.cdi;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Priority;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.apache.camel.test.cdi.AnnotatedMethodDecorator;
import org.apache.camel.test.cdi.AnnotatedTypeDecorator;
import org.apache.camel.test.cdi.Beans;
import org.apache.camel.test.cdi.PriorityLiteral;

final class CamelCdiTestExtension
implements Extension {
    private final Beans beans;

    CamelCdiTestExtension(Beans beans) {
        this.beans = beans;
    }

    private <T> void alternatives(@Observes @WithAnnotations(value={Alternative.class}) ProcessAnnotatedType<T> pat) {
        AnnotatedType type = pat.getAnnotatedType();
        if (!Arrays.asList(this.beans.alternatives()).contains(type.getJavaClass())) {
            return;
        }
        HashSet methods = new HashSet();
        for (AnnotatedMethod method : type.getMethods()) {
            if (!method.isAnnotationPresent(Alternative.class) || method.isAnnotationPresent(Priority.class)) continue;
            methods.add(new AnnotatedMethodDecorator(method, (Annotation)((Object)PriorityLiteral.of(2000))));
        }
        if (type.isAnnotationPresent(Alternative.class) && !type.isAnnotationPresent(Priority.class)) {
            pat.setAnnotatedType(new AnnotatedTypeDecorator(type, (Annotation)((Object)PriorityLiteral.of(2000)), methods));
        } else if (!methods.isEmpty()) {
            pat.setAnnotatedType(new AnnotatedTypeDecorator(type, methods));
        }
    }
}

