/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.cdi;

import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.inject.spi.BeanManager;

final class CamelCdiContext {
    private final AtomicReference<BeanManager> manager = new AtomicReference();

    CamelCdiContext() {
    }

    BeanManager getBeanManager() {
        BeanManager manager = this.manager.get();
        if (manager == null) {
            throw new IllegalStateException("Bean manager is not set!");
        }
        return manager;
    }

    void setBeanManager(BeanManager manager) {
        if (!this.manager.compareAndSet(null, manager)) {
            throw new IllegalStateException("Bean manager already set!");
        }
    }

    void unsetBeanManager() {
        if (this.manager.getAndSet(null) == null) {
            throw new IllegalStateException("Bean manager is not set!");
        }
    }
}

