/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.SafeCopyProperty;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExchangeVariableRepository;
import org.apache.camel.support.ExtendedExchangeExtension;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.trait.message.MessageTrait;
import org.apache.camel.trait.message.RedeliveryTraitPayload;
import org.apache.camel.util.ObjectHelper;

abstract class AbstractExchange
implements Exchange {
    protected final EnumMap<ExchangePropertyKey, Object> internalProperties;
    protected final CamelContext context;
    protected Map<String, Object> properties;
    protected Message in;
    protected Message out;
    protected Exception exception;
    protected String exchangeId;
    protected ExchangePattern pattern;
    protected boolean routeStop;
    protected boolean rollbackOnly;
    protected boolean rollbackOnlyLast;
    protected Map<String, SafeCopyProperty> safeCopyProperties;
    protected ExchangeVariableRepository variableRepository;
    private final ExtendedExchangeExtension privateExtension;
    private RedeliveryTraitPayload externalRedelivered = RedeliveryTraitPayload.UNDEFINED_REDELIVERY;

    protected AbstractExchange(CamelContext context, EnumMap<ExchangePropertyKey, Object> internalProperties, Map<String, Object> properties) {
        this.context = context;
        this.internalProperties = new EnumMap<ExchangePropertyKey, Object>(internalProperties);
        this.privateExtension = new ExtendedExchangeExtension(this);
        this.properties = AbstractExchange.safeCopyProperties(properties);
    }

    protected AbstractExchange(CamelContext context) {
        this(context, ExchangePattern.InOnly);
    }

    protected AbstractExchange(CamelContext context, ExchangePattern pattern) {
        this.context = context;
        this.pattern = pattern;
        this.internalProperties = new EnumMap(ExchangePropertyKey.class);
        this.privateExtension = new ExtendedExchangeExtension(this);
    }

    protected AbstractExchange(Exchange parent) {
        this.context = parent.getContext();
        this.pattern = parent.getPattern();
        this.internalProperties = new EnumMap(ExchangePropertyKey.class);
        this.privateExtension = new ExtendedExchangeExtension(this);
        this.privateExtension.setFromEndpoint(parent.getFromEndpoint());
        this.privateExtension.setFromRouteId(parent.getFromRouteId());
        this.privateExtension.setUnitOfWork(parent.getUnitOfWork());
    }

    protected AbstractExchange(AbstractExchange parent) {
        this.context = parent.getContext();
        this.pattern = parent.getPattern();
        this.internalProperties = new EnumMap<ExchangePropertyKey, Object>(parent.internalProperties);
        this.privateExtension = new ExtendedExchangeExtension(this);
        this.privateExtension.setFromEndpoint(parent.getFromEndpoint());
        this.privateExtension.setFromRouteId(parent.getFromRouteId());
        this.privateExtension.setUnitOfWork(parent.getUnitOfWork());
        this.setIn(parent.getIn().copy());
        if (parent.hasOut()) {
            this.setOut(parent.getOut().copy());
        }
        this.setException(parent.exception);
        this.setRouteStop(parent.routeStop);
        this.setRollbackOnly(parent.rollbackOnly);
        this.setRollbackOnlyLast(parent.rollbackOnlyLast);
        this.privateExtension.setNotifyEvent(parent.getExchangeExtension().isNotifyEvent());
        this.privateExtension.setRedeliveryExhausted(parent.getExchangeExtension().isRedeliveryExhausted());
        this.privateExtension.setErrorHandlerHandled(parent.getExchangeExtension().getErrorHandlerHandled());
        this.privateExtension.setStreamCacheDisabled(parent.getExchangeExtension().isStreamCacheDisabled());
        if (parent.hasVariables()) {
            if (this.variableRepository == null) {
                this.variableRepository = new ExchangeVariableRepository(this.getContext());
            }
            this.variableRepository.copyFrom(parent.variableRepository);
        }
        if (parent.hasProperties()) {
            this.properties = AbstractExchange.safeCopyProperties(parent.properties);
        }
        if (parent.hasSafeCopyProperties()) {
            this.safeCopyProperties = parent.copySafeCopyProperties();
        }
    }

    public long getCreated() {
        return this.getClock().getCreated();
    }

    abstract AbstractExchange newCopy();

    public Exchange copy() {
        AbstractExchange exchange = this.newCopy();
        if (this.getContext().isMessageHistory().booleanValue()) {
            exchange.internalProperties.computeIfPresent(ExchangePropertyKey.MESSAGE_HISTORY, (k, v) -> new CopyOnWriteArrayList((List)v));
        }
        return exchange;
    }

    public CamelContext getContext() {
        return this.context;
    }

    public Object getProperty(ExchangePropertyKey key) {
        return this.internalProperties.get(key);
    }

    public <T> T getProperty(ExchangePropertyKey key, Class<T> type) {
        Object value = this.getProperty(key);
        return this.evalPropertyValue(type, value);
    }

    private <T> T evalPropertyValue(Class<T> type, Object value) {
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    private <T> T evalPropertyValue(Object defaultValue, Class<T> type, Object value) {
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    public <T> T getProperty(ExchangePropertyKey key, Object defaultValue, Class<T> type) {
        Object value = this.getProperty(key);
        return this.evalPropertyValue(defaultValue, type, value);
    }

    public void setProperty(ExchangePropertyKey key, Object value) {
        this.internalProperties.put(key, value);
    }

    public Object removeProperty(ExchangePropertyKey key) {
        return this.internalProperties.remove(key);
    }

    public Object getProperty(String name) {
        Object answer = null;
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey((String)name);
        if (key != null) {
            answer = this.internalProperties.get(key);
        }
        if (answer == null && this.properties != null) {
            answer = this.properties.get(name);
        }
        return answer;
    }

    public <T> T getProperty(String name, Class<T> type) {
        Object value = this.getProperty(name);
        return this.evalPropertyValue(type, value);
    }

    public <T> T getProperty(String name, Object defaultValue, Class<T> type) {
        Object value = this.getProperty(name);
        return this.evalPropertyValue(defaultValue, type, value);
    }

    public void setProperty(String name, Object value) {
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey((String)name);
        if (key != null) {
            this.setProperty(key, value);
        } else if (value != null) {
            if (this.properties == null) {
                this.properties = new ConcurrentHashMap<String, Object>(8);
            }
            this.properties.put(name, value);
        } else if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    void setProperties(Map<String, Object> properties) {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, Object>(8);
        } else {
            this.properties.clear();
        }
        this.properties.putAll(properties);
    }

    public Object removeProperty(String name) {
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey((String)name);
        if (key != null) {
            return this.removeProperty(key);
        }
        if (!this.hasProperties()) {
            return null;
        }
        return this.properties.remove(name);
    }

    public boolean removeProperties(String pattern) {
        return this.removeProperties(pattern, null);
    }

    public boolean removeProperties(String pattern, String ... excludePatterns) {
        Set<String> toBeRemoved;
        if (excludePatterns == null && "*".equals(pattern)) {
            if (this.properties != null) {
                this.properties.clear();
            }
            this.internalProperties.clear();
            return true;
        }
        boolean matches = false;
        for (ExchangePropertyKey epk : ExchangePropertyKey.values()) {
            String key = epk.getName();
            if (!PatternHelper.matchPattern(key, pattern) || excludePatterns != null && PatternHelper.isExcludePatternMatch(key, excludePatterns)) continue;
            matches = true;
            this.internalProperties.remove(epk);
        }
        if (this.properties != null && (toBeRemoved = PatternHelper.matchingSet(this.properties, pattern, excludePatterns)) != null) {
            matches = true;
            if (toBeRemoved.size() == this.properties.size()) {
                this.properties.clear();
            } else {
                for (String key : toBeRemoved) {
                    this.properties.remove(key);
                }
            }
        }
        return matches;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, Object>(8);
        }
        return this.properties;
    }

    private Map<String, SafeCopyProperty> copySafeCopyProperties() {
        ConcurrentHashMap<String, SafeCopyProperty> copy = new ConcurrentHashMap<String, SafeCopyProperty>();
        for (Map.Entry<String, SafeCopyProperty> entry : this.safeCopyProperties.entrySet()) {
            copy.put(entry.getKey(), entry.getValue().safeCopy());
        }
        return copy;
    }

    public Map<String, Object> getAllProperties() {
        Map<String, Object> map = this.getInternalProperties();
        if (this.properties != null && !this.properties.isEmpty()) {
            map.putAll(this.properties);
        }
        return map;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    private boolean hasSafeCopyProperties() {
        return this.safeCopyProperties != null && !this.safeCopyProperties.isEmpty();
    }

    public Object getVariable(String name) {
        if (this.variableRepository != null) {
            return this.variableRepository.getVariable(name);
        }
        return null;
    }

    public <T> T getVariable(String name, Class<T> type) {
        Object value = this.getVariable(name);
        return this.evalPropertyValue(type, value);
    }

    public <T> T getVariable(String name, Object defaultValue, Class<T> type) {
        Object value = this.getVariable(name);
        return this.evalPropertyValue(defaultValue, type, value);
    }

    public void setVariable(String name, Object value) {
        if (this.variableRepository == null) {
            this.variableRepository = new ExchangeVariableRepository(this.getContext());
        }
        this.variableRepository.setVariable(name, value);
    }

    public Object removeVariable(String name) {
        if (this.variableRepository != null) {
            if ("*".equals(name)) {
                this.variableRepository.clear();
                return null;
            }
            return this.variableRepository.removeVariable(name);
        }
        return null;
    }

    public Map<String, Object> getVariables() {
        if (this.variableRepository == null) {
            this.variableRepository = new ExchangeVariableRepository(this.getContext());
        }
        return this.variableRepository.getVariables();
    }

    public boolean hasVariables() {
        if (this.variableRepository != null) {
            return this.variableRepository.hasVariables();
        }
        return false;
    }

    public Message getIn() {
        if (this.in == null) {
            this.in = new DefaultMessage(this.getContext());
            this.configureMessage(this.in);
        }
        return this.in;
    }

    public <T> T getIn(Class<T> type) {
        Message in = this.getIn();
        if (type.isInstance(in)) {
            return type.cast(in);
        }
        return (T)this.context.getTypeConverter().convertTo(type, (Exchange)this, (Object)in);
    }

    <T> T getInOrNull(Class<T> type) {
        if (this.in == null) {
            return null;
        }
        if (type.isInstance(this.in)) {
            return type.cast(this.in);
        }
        return null;
    }

    public void setIn(Message in) {
        this.in = in;
        this.configureMessage(in);
    }

    public Message getOut() {
        if (this.out == null) {
            this.out = this.in instanceof MessageSupport ? ((MessageSupport)this.in).newInstance() : new DefaultMessage(this.getContext());
            this.configureMessage(this.out);
        }
        return this.out;
    }

    public <T> T getOut(Class<T> type) {
        if (!this.hasOut()) {
            return null;
        }
        Message out = this.getOut();
        if (type.isInstance(out)) {
            return type.cast(out);
        }
        return (T)this.context.getTypeConverter().convertTo(type, (Exchange)this, (Object)out);
    }

    public boolean hasOut() {
        return this.out != null;
    }

    public void setOut(Message out) {
        this.out = out;
        this.configureMessage(out);
    }

    public Message getMessage() {
        return this.hasOut() ? this.getOut() : this.getIn();
    }

    public <T> T getMessage(Class<T> type) {
        return this.hasOut() ? this.getOut(type) : this.getIn(type);
    }

    public void setMessage(Message message) {
        if (this.hasOut()) {
            this.setOut(message);
        } else {
            this.setIn(message);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public <T> T getException(Class<T> type) {
        return (T)ObjectHelper.getException(type, (Throwable)this.exception);
    }

    public void setException(Throwable t) {
        this.exception = t == null ? null : (t instanceof Exception ? (Exception)t : CamelExecutionException.wrapCamelExecutionException((Exchange)this, (Throwable)t));
        if (t instanceof InterruptedException) {
            this.privateExtension.setInterrupted(true);
        }
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public Endpoint getFromEndpoint() {
        return this.privateExtension.getFromEndpoint();
    }

    public String getFromRouteId() {
        return this.privateExtension.getFromRouteId();
    }

    public String getExchangeId() {
        if (this.exchangeId == null) {
            this.exchangeId = this.createExchangeId();
        }
        return this.exchangeId;
    }

    public void setExchangeId(String id) {
        this.exchangeId = id;
    }

    public boolean isFailed() {
        return this.exception != null;
    }

    public boolean isTransacted() {
        return this.privateExtension.isTransacted();
    }

    public boolean isRouteStop() {
        return this.routeStop;
    }

    public void setRouteStop(boolean routeStop) {
        this.routeStop = routeStop;
    }

    public boolean isExternalRedelivered() {
        if (this.externalRedelivered == RedeliveryTraitPayload.UNDEFINED_REDELIVERY) {
            Message message = this.getIn();
            this.externalRedelivered = (RedeliveryTraitPayload)message.getPayloadForTrait(MessageTrait.REDELIVERY);
        }
        return this.externalRedelivered == RedeliveryTraitPayload.IS_REDELIVERY;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setRollbackOnly(boolean rollbackOnly) {
        this.rollbackOnly = rollbackOnly;
    }

    public boolean isRollbackOnlyLast() {
        return this.rollbackOnlyLast;
    }

    public void setRollbackOnlyLast(boolean rollbackOnlyLast) {
        this.rollbackOnlyLast = rollbackOnlyLast;
    }

    public UnitOfWork getUnitOfWork() {
        return this.privateExtension.getUnitOfWork();
    }

    protected void configureMessage(Message message) {
        if (message instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)message;
            messageSupport.setExchange(this);
            messageSupport.setCamelContext(this.getContext());
        }
    }

    void copyInternalProperties(Exchange target) {
        ((AbstractExchange)target).internalProperties.putAll(this.internalProperties);
    }

    Map<String, Object> getInternalProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ExchangePropertyKey key : ExchangePropertyKey.values()) {
            Object value = this.internalProperties.get(key);
            if (value == null) continue;
            map.put(key.getName(), value);
        }
        return map;
    }

    protected String createExchangeId() {
        return this.context.getUuidGenerator().generateExchangeUuid();
    }

    public final String toString() {
        if (this.exchangeId != null) {
            return "Exchange[" + this.exchangeId + "]";
        }
        return "Exchange[]";
    }

    void setSafeCopyProperty(String key, SafeCopyProperty value) {
        if (value != null) {
            if (this.safeCopyProperties == null) {
                this.safeCopyProperties = new ConcurrentHashMap<String, SafeCopyProperty>(2);
            }
            this.safeCopyProperties.put(key, value);
        } else if (this.safeCopyProperties != null) {
            this.safeCopyProperties.remove(key);
        }
    }

    <T> T getSafeCopyProperty(String key, Class<T> type) {
        if (!this.hasSafeCopyProperties()) {
            return null;
        }
        SafeCopyProperty value = this.safeCopyProperties.get(key);
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    public ExtendedExchangeExtension getExchangeExtension() {
        return this.privateExtension;
    }

    private static Map<String, Object> safeCopyProperties(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        return new ConcurrentHashMap<String, Object>(properties);
    }
}

