/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.cache.SimpleLRUCache;
import org.apache.camel.support.cache.SimpleSoftCache;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLRUCacheFactory
extends LRUCacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLRUCacheFactory.class);

    @Override
    public <K, V> Map<K, V> createLRUCache(int maximumCacheSize) {
        return this.createLRUCache(16, maximumCacheSize);
    }

    @Override
    public <K, V> Map<K, V> createLRUCache(int maximumCacheSize, Consumer<V> onEvict) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}, with onEvict", (Object)16, (Object)maximumCacheSize);
        return new SimpleLRUCache(16, maximumCacheSize, onEvict);
    }

    @Override
    public <K, V> Map<K, V> createLRUCache(int initialCapacity, int maximumCacheSize) {
        return this.createLRUCache(initialCapacity, maximumCacheSize, maximumCacheSize > 0);
    }

    @Override
    public <K, V> Map<K, V> createLRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}, stopOnEviction: {}", new Object[]{initialCapacity, maximumCacheSize, stopOnEviction});
        return new SimpleLRUCache(initialCapacity, maximumCacheSize, stopOnEviction ? this::doStop : this::doNothing);
    }

    @Override
    public <K, V> Map<K, V> createLRUSoftCache(int maximumCacheSize) {
        return this.createLRUSoftCache(16, maximumCacheSize);
    }

    @Override
    public <K, V> Map<K, V> createLRUSoftCache(int initialCapacity, int maximumCacheSize) {
        return this.createLRUSoftCache(initialCapacity, maximumCacheSize, maximumCacheSize > 0);
    }

    @Override
    public <K, V> Map<K, V> createLRUSoftCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        LOG.trace("Creating LRUSoftCache with initialCapacity: {}, maximumCacheSize: {}, stopOnEviction: {}", new Object[]{initialCapacity, maximumCacheSize, stopOnEviction});
        return new SimpleSoftCache(new SimpleLRUCache(initialCapacity, maximumCacheSize, DefaultLRUCacheFactory.asSoftReferenceConsumer(stopOnEviction ? this::doStop : this::doNothing)));
    }

    private static <V> Consumer<SoftReference<V>> asSoftReferenceConsumer(Consumer<V> evicted) {
        return ref -> {
            Object v = ref.get();
            if (v != null) {
                evicted.accept(v);
            }
        };
    }

    @Override
    @Deprecated(since="4.2.0")
    public <K, V> Map<K, V> createLRUWeakCache(int maximumCacheSize) {
        return this.createLRUWeakCache(16, maximumCacheSize);
    }

    @Override
    @Deprecated(since="4.2.0")
    public <K, V> Map<K, V> createLRUWeakCache(int initialCapacity, int maximumCacheSize) {
        return this.createLRUWeakCache(initialCapacity, maximumCacheSize, maximumCacheSize > 0);
    }

    @Override
    @Deprecated(since="4.2.0")
    public <K, V> Map<K, V> createLRUWeakCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        LOG.trace("Creating LRUWeakCache with initialCapacity: {}, maximumCacheSize: {}, stopOnEviction: {}", new Object[]{initialCapacity, maximumCacheSize, stopOnEviction});
        return new SimpleSoftCache(new SimpleLRUCache(initialCapacity, maximumCacheSize, DefaultLRUCacheFactory.asSoftReferenceConsumer(stopOnEviction ? this::doStop : this::doNothing)));
    }

    <V> void doNothing(V value) {
    }

    <V> void doStop(V value) {
        try {
            ServiceHelper.stopService(value);
        }
        catch (Exception e) {
            LOG.warn("Error stopping service: {}. This exception will be ignored.", value, (Object)e);
        }
    }
}

