/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RouteTemplateLoaderListener;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RouteTemplateHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RouteTemplateHelper.class);

    private RouteTemplateHelper() {
    }

    /*
     * WARNING - void declaration
     */
    public static void loadRouteTemplateFromLocation(CamelContext camelContext, RouteTemplateLoaderListener listener, String templateId, String location) throws Exception {
        if (location == null) {
            throw new IllegalArgumentException("Location is empty");
        }
        ExtendedCamelContext ecc = (ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class);
        boolean found = false;
        for (String string : location.split(",")) {
            void var9_14;
            if (".".equals(string) || "file:.".equals(string)) {
                String string3 = new File(".").getAbsolutePath();
                string3 = "file:" + FileUtil.onlyPath((String)string3);
            }
            String name = var9_14;
            Resource res = null;
            String ext = FileUtil.onlyExt((String)var9_14);
            if (ext != null && !ext.isEmpty()) {
                res = ecc.getResourceLoader().resolveResource(name);
            }
            if (res == null || !res.exists()) {
                void var9_10;
                if (!var9_14.endsWith("/")) {
                    String string4 = (String)var9_14 + "/";
                }
                name = (String)var9_10 + templateId + ".kamelet.yaml";
                res = ecc.getResourceLoader().resolveResource(name);
            }
            if (!res.exists()) continue;
            try {
                if (listener != null) {
                    listener.loadRouteTemplate(res);
                }
            }
            catch (Exception e) {
                LOG.warn("RouteTemplateLoaderListener error due to " + e.getMessage() + ". This exception is ignored", (Throwable)e);
            }
            ecc.getRoutesLoader().loadRoutes(new Resource[]{res});
            found = true;
            break;
        }
        if (!found) {
            Object path = location;
            if (".".equals(path) || "file:.".equals(path)) {
                path = new File(".").getAbsolutePath();
                path = "file:" + FileUtil.onlyPath((String)path);
            }
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            String target = (String)path + templateId + ".kamelet.yaml";
            ecc.getRoutesLoader().loadRoutes(new Resource[]{ecc.getResourceLoader().resolveResource(target)});
        }
    }
}

