/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceHelper.class);

    private ResourceHelper() {
    }

    public static boolean hasScheme(String uri) {
        if (uri == null) {
            return false;
        }
        return uri.startsWith("file:") || uri.startsWith("classpath:") || uri.startsWith("http:");
    }

    public static String getScheme(String uri) {
        if (ResourceHelper.hasScheme(uri)) {
            return uri.substring(0, uri.indexOf(58) + 1);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputStream resolveMandatoryResourceAsInputStream(CamelContext camelContext, String uri) throws IOException {
        InputStream is;
        if (uri.startsWith("ref:")) {
            String ref = uri.substring(4);
            String value = CamelContextHelper.mandatoryLookup(camelContext, ref, String.class);
            return new ByteArrayInputStream(value.getBytes());
        }
        if (uri.startsWith("bean:")) {
            String bean = uri.substring(5);
            DefaultExchange dummy = new DefaultExchange(camelContext);
            Object out = camelContext.resolveLanguage("bean").createExpression(bean).evaluate((Exchange)dummy, Object.class);
            if (dummy.getException() != null) {
                IOException io = new IOException("Cannot find resource: " + uri + " from calling the bean");
                io.initCause(dummy.getException());
                throw io;
            }
            if (out == null) throw new IOException("Cannot find resource: " + uri + " from calling the bean");
            InputStream is2 = (InputStream)camelContext.getTypeConverter().tryConvertTo(InputStream.class, (Exchange)dummy, out);
            if (is2 != null) return is2;
            String text = (String)camelContext.getTypeConverter().tryConvertTo(String.class, (Exchange)dummy, out);
            if (text != null) {
                return new ByteArrayInputStream(text.getBytes());
            }
        }
        if ((is = ResourceHelper.resolveResourceAsInputStream(camelContext.getClassResolver(), uri)) != null) return is;
        String resolvedName = ResourceHelper.resolveUriPath(uri);
        throw new FileNotFoundException("Cannot find resource: " + resolvedName + " in classpath for URI: " + uri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputStream resolveResourceAsInputStream(CamelContext camelContext, String uri) throws IOException {
        if (uri.startsWith("ref:")) {
            String ref = uri.substring(4);
            String value = CamelContextHelper.mandatoryLookup(camelContext, ref, String.class);
            return new ByteArrayInputStream(value.getBytes());
        }
        if (!uri.startsWith("bean:")) return ResourceHelper.resolveResourceAsInputStream(camelContext.getClassResolver(), uri);
        String bean = uri.substring(5);
        DefaultExchange dummy = new DefaultExchange(camelContext);
        Object out = camelContext.resolveLanguage("bean").createExpression(bean).evaluate((Exchange)dummy, Object.class);
        if (dummy.getException() != null) {
            IOException io = new IOException("Cannot find resource: " + uri + " from calling the bean");
            io.initCause(dummy.getException());
            throw io;
        }
        if (out == null) throw new IOException("Cannot find resource: " + uri + " from calling the bean");
        InputStream is = (InputStream)camelContext.getTypeConverter().tryConvertTo(InputStream.class, (Exchange)dummy, out);
        if (is != null) return is;
        String text = (String)camelContext.getTypeConverter().tryConvertTo(String.class, (Exchange)dummy, out);
        if (text == null) return ResourceHelper.resolveResourceAsInputStream(camelContext.getClassResolver(), uri);
        return new ByteArrayInputStream(text.getBytes());
    }

    public static InputStream resolveResourceAsInputStream(ClassResolver classResolver, String uri) throws IOException {
        if (uri.startsWith("file:")) {
            uri = StringHelper.after((String)uri, (String)"file:");
            uri = ResourceHelper.tryDecodeUri(uri);
            LOG.trace("Loading resource: {} from file system", (Object)uri);
            return new FileInputStream(uri);
        }
        if (uri.startsWith("http:")) {
            URL url = new URL(uri);
            LOG.trace("Loading resource: {} from HTTP", (Object)uri);
            URLConnection con = url.openConnection();
            con.setUseCaches(false);
            try {
                return con.getInputStream();
            }
            catch (IOException e) {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                throw e;
            }
        }
        if (uri.startsWith("classpath:")) {
            uri = StringHelper.after((String)uri, (String)"classpath:");
            uri = ResourceHelper.tryDecodeUri(uri);
        } else if (uri.contains(":")) {
            LOG.trace("Loading resource: {} with UrlHandler for protocol {}", (Object)uri, (Object)uri.split(":")[0]);
            URL url = new URL(uri);
            URLConnection con = url.openConnection();
            return con.getInputStream();
        }
        String resolvedName = ResourceHelper.resolveUriPath(uri);
        LOG.trace("Loading resource: {} from classpath", (Object)resolvedName);
        return classResolver.loadResourceAsStream(resolvedName);
    }

    public static URL resolveMandatoryResourceAsUrl(ClassResolver classResolver, String uri) throws FileNotFoundException, MalformedURLException {
        URL url = ResourceHelper.resolveResourceAsUrl(classResolver, uri);
        if (url == null) {
            String resolvedName = ResourceHelper.resolveUriPath(uri);
            throw new FileNotFoundException("Cannot find resource: " + resolvedName + " in classpath for URI: " + uri);
        }
        return url;
    }

    public static URL resolveResourceAsUrl(ClassResolver classResolver, String uri) throws MalformedURLException {
        if (uri.startsWith("file:")) {
            String name = StringHelper.after((String)uri, (String)"file:");
            uri = ResourceHelper.tryDecodeUri(uri);
            LOG.trace("Loading resource: {} from file system", (Object)uri);
            File file = new File(name);
            if (!file.exists()) {
                return null;
            }
            return new URL(uri);
        }
        if (uri.startsWith("http:")) {
            LOG.trace("Loading resource: {} from HTTP", (Object)uri);
            return new URL(uri);
        }
        if (uri.startsWith("classpath:")) {
            uri = StringHelper.after((String)uri, (String)"classpath:");
            uri = ResourceHelper.tryDecodeUri(uri);
        } else if (uri.contains(":")) {
            LOG.trace("Loading resource: {} with UrlHandler for protocol {}", (Object)uri, (Object)uri.split(":")[0]);
            return new URL(uri);
        }
        String resolvedName = ResourceHelper.resolveUriPath(uri);
        LOG.trace("Loading resource: {} from classpath", (Object)resolvedName);
        return classResolver.loadResourceAsURL(resolvedName);
    }

    public static boolean isClasspathUri(String uri) {
        if (ObjectHelper.isEmpty((Object)uri)) {
            return false;
        }
        return uri.startsWith("classpath:") || uri.indexOf(58) == -1;
    }

    public static boolean isHttpUri(String uri) {
        if (ObjectHelper.isEmpty((Object)uri)) {
            return false;
        }
        return uri.startsWith("http:") || uri.startsWith("https:");
    }

    public static String appendParameters(String uri, Map<String, Object> parameters) throws URISyntaxException {
        if (!parameters.isEmpty()) {
            String query = URISupport.createQueryString(parameters);
            URI u = new URI(uri);
            u = URISupport.createURIWithQuery((URI)u, (String)query);
            parameters.clear();
            return u.toString();
        }
        return uri;
    }

    private static String resolveUriPath(String name) {
        return FileUtil.compactPath((String)name, (char)'/');
    }

    private static String tryDecodeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (Exception e) {
            LOG.trace("Error URL decoding uri using UTF-8 encoding: {}. This exception is ignored.", (Object)uri);
        }
        return uri;
    }

    public static Set<Path> findInFileSystem(Path root, String pattern) throws Exception {
        try (Stream<Path> path = Files.walk(root, new FileVisitOption[0]);){
            Set set = path.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(entry -> {
                Path relative = root.relativize((Path)entry);
                String str = relative.toString().replaceAll(Pattern.quote(File.separator), "/");
                boolean match = AntPathMatcher.INSTANCE.match(pattern, str);
                LOG.debug("Found resource: {} matching pattern: {} -> {}", new Object[]{entry, pattern, match});
                return match;
            }).collect(Collectors.toCollection(LinkedHashSet::new));
            return set;
        }
    }
}

