/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StartupSummaryLevel;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.FileWatcherResourceReloadStrategy;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteWatcherReloadStrategy
extends FileWatcherResourceReloadStrategy {
    public static final String RELOAD_RESOURCES = "RouteWatcherReloadResources";
    private static final Logger LOG = LoggerFactory.getLogger(RouteWatcherReloadStrategy.class);
    private static final String DEFAULT_PATTERN = "*.yaml,*.xml";
    private String pattern;
    private boolean removeAllRoutes = true;
    private final List<Resource> previousSources = new ArrayList<Resource>();

    public RouteWatcherReloadStrategy() {
    }

    public RouteWatcherReloadStrategy(String directory) {
        this(directory, false);
    }

    public RouteWatcherReloadStrategy(String directory, boolean recursive) {
        super(directory, recursive);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean isRemoveAllRoutes() {
        return this.removeAllRoutes;
    }

    public void setRemoveAllRoutes(boolean removeAllRoutes) {
        this.removeAllRoutes = removeAllRoutes;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.getFolder(), (String)"folder", (Object)((Object)this));
        if (this.pattern == null || this.pattern.isBlank()) {
            this.pattern = DEFAULT_PATTERN;
        } else if ("*".equals(this.pattern)) {
            this.pattern = "**";
        }
        String base = new File(this.getFolder()).getAbsolutePath();
        AntPathMatcher matcher = new AntPathMatcher();
        if (this.getFileFilter() == null) {
            String[] parts = this.pattern.split(",");
            this.setFileFilter(f -> {
                for (String part : parts) {
                    String path = f.getAbsolutePath();
                    if (path.startsWith(base)) {
                        path = FileUtil.stripPath((String)path);
                    }
                    boolean result = matcher.match(part, path, false);
                    LOG.trace("Accepting file pattern:{} path:{} -> {}", new Object[]{part, path, result});
                    if (!result) continue;
                    return true;
                }
                return false;
            });
        }
        if (this.getResourceReload() == null) {
            this.setResourceReload((name, resource) -> {
                if (name.endsWith(".properties")) {
                    this.onPropertiesReload(resource);
                } else {
                    this.onRouteReload(resource);
                }
            });
        }
        super.doStart();
    }

    @Override
    protected String startupMessage(File dir) {
        return "Live route reloading enabled (directory: " + dir + ")";
    }

    protected void onPropertiesReload(Resource resource) {
        LOG.info("Reloading properties: {}. (Only Camel routes can be updated with changes)", (Object)resource.getLocation());
        PropertiesComponent pc = this.getCamelContext().getPropertiesComponent();
        boolean reloaded = pc.reloadProperties(resource.getLocation());
        if (reloaded) {
            this.onRouteReload(null);
        }
    }

    protected void onRouteReload(Resource resource) {
        ArrayList<Resource> sources = new ArrayList<Resource>();
        if (!this.previousSources.isEmpty()) {
            this.previousSources.forEach(rs -> {
                if (rs != null && !RouteWatcherReloadStrategy.equalResourceLocation(resource, rs)) {
                    sources.add((Resource)rs);
                }
            });
        }
        try {
            int total;
            Collection extras;
            if (this.removeAllRoutes) {
                this.getCamelContext().getRoutes().forEach(r -> {
                    Resource rs = r.getSourceResource();
                    if (rs != null && !RouteWatcherReloadStrategy.equalResourceLocation(resource, rs)) {
                        sources.add(rs);
                    }
                });
                this.getCamelContext().getRouteController().removeAllRoutes();
                this.getCamelContext().removeRouteTemplates("*");
                this.getCamelContext().getEndpointRegistry().clear();
            }
            if (resource != null && Files.exists(Paths.get(resource.getURI()), new LinkOption[0])) {
                sources.add(resource);
            }
            if ((extras = (Collection)this.getCamelContext().getRegistry().lookupByNameAndType(RELOAD_RESOURCES, Collection.class)) != null) {
                for (Resource extra : extras) {
                    if (sources.contains(extra)) continue;
                    sources.add(extra);
                }
            }
            this.previousSources.clear();
            this.previousSources.addAll(sources);
            Set ids = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getRoutesLoader().updateRoutes(sources);
            this.previousSources.clear();
            if (!ids.isEmpty()) {
                ArrayList<String> lines = new ArrayList<String>();
                total = 0;
                int started = 0;
                for (String id : ids) {
                    ++total;
                    String status = this.getCamelContext().getRouteController().getRouteStatus(id).name();
                    if (ServiceStatus.Started.name().equals(status)) {
                        ++started;
                    }
                    Route route = this.getCamelContext().getRoute(id);
                    String uri = route.getEndpoint().getEndpointBaseUri();
                    uri = URISupport.sanitizeUri((String)uri);
                    String loc = route.getSourceResource() != null ? route.getSourceResource().getLocation() : "";
                    lines.add(String.format("    %s %s (%s) (source: %s)", status, id, uri, loc));
                }
                LOG.info(String.format("Routes reloaded summary (total:%s started:%s)", total, started));
                if (this.getCamelContext().getStartupSummaryLevel() == StartupSummaryLevel.Default || this.getCamelContext().getStartupSummaryLevel() == StartupSummaryLevel.Verbose) {
                    for (String line : lines) {
                        LOG.info(line);
                    }
                }
            }
            int index = 1;
            total = ids.size();
            for (String id : ids) {
                Route route = this.getCamelContext().getRoute(id);
                EventHelper.notifyRouteReloaded(this.getCamelContext(), route, index++, total);
            }
            if (!this.removeAllRoutes) {
                StringJoiner sj = new StringJoiner("\n    ");
                for (String id : ids) {
                    Route route = this.getCamelContext().getRoute(id);
                    if (!route.isCustomId()) continue;
                    sj.add(route.getEndpoint().getEndpointUri());
                }
                if (sj.length() > 0) {
                    LOG.warn("Routes with no id's detected. Its recommended to assign route id's to your routes so Camel can reload the routes correctly.\n    Unassigned routes:\n    {}", (Object)sj);
                }
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
    }

    private static boolean equalResourceLocation(Resource source, Resource target) {
        URI u2;
        if (source == null || target == null) {
            return false;
        }
        URI u1 = source.getURI();
        boolean answer = u1.equals(u2 = target.getURI());
        if (!answer) {
            String s1 = u1.toString().replace("src/main/resources/", "").replace("src/test/resources/", "").replace("target/classes/", "");
            String s2 = u2.toString().replace("src/main/resources/", "").replace("src/test/resources/", "").replace("target/classes/", "");
            answer = s1.equals(s2);
        }
        return answer;
    }
}

