/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Traceable;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class UnmarshalProcessor
extends AsyncProcessorSupport
implements Traceable,
CamelContextAware,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private CamelContext camelContext;
    private final DataFormat dataFormat;

    public UnmarshalProcessor(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        ObjectHelper.notNull((Object)this.dataFormat, (String)"dataFormat");
        InputStream stream = null;
        Object result = null;
        try {
            stream = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            result = this.dataFormat.unmarshal(exchange, stream);
            if (result instanceof Exchange) {
                if (result != exchange) {
                    throw new RuntimeCamelException("The returned exchange " + result + " is not the same as " + exchange + " provided to the DataFormat");
                }
            } else if (result instanceof Message) {
                exchange.setOut((Message)result);
            } else {
                out.setBody(result);
            }
        }
        catch (Throwable e) {
            exchange.setOut(null);
            exchange.setException(e);
        }
        finally {
            if (!(result instanceof Iterator)) {
                IOHelper.close((Closeable)stream, (String)"input stream");
            }
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "Unmarshal[" + this.dataFormat + "]";
    }

    public String getTraceLabel() {
        return "unmarshal[" + this.dataFormat + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    protected void doStart() throws Exception {
        CamelContextAware.trySetCamelContext((Object)this.dataFormat, (CamelContext)this.camelContext);
        this.getCamelContext().addService((Object)this.dataFormat, false, true);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.dataFormat);
        this.getCamelContext().removeService((Object)this.dataFormat);
    }
}

