/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.service.ServiceSupport;

public abstract class PollingConsumerSupport
extends ServiceSupport
implements PollingConsumer {
    private final Endpoint endpoint;
    private ExceptionHandler exceptionHandler;

    public PollingConsumerSupport(Endpoint endpoint) {
        this.endpoint = endpoint;
        this.exceptionHandler = new LoggingExceptionHandler(endpoint.getCamelContext(), ((Object)((Object)this)).getClass());
    }

    public String toString() {
        return "PollingConsumer on " + this.endpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Processor getProcessor() {
        return null;
    }

    public Exchange createExchange(boolean autoRelease) {
        throw new UnsupportedOperationException("Not supported on PollingConsumer");
    }

    public void releaseExchange(Exchange exchange, boolean autoRelease) {
        throw new UnsupportedOperationException("Not supported on PollingConsumer");
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected void handleException(Throwable t) {
        this.getExceptionHandler().handleException(t);
    }
}

