/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task.budget;

import java.time.Duration;
import java.time.Instant;
import org.apache.camel.support.task.budget.IterationBoundedBudget;
import org.apache.camel.support.task.budget.IterationBudget;
import org.apache.camel.support.task.budget.TimeBudget;

public class IterationTimeBoundedBudget
implements IterationBudget,
TimeBudget {
    private IterationBudget iterationBudget;
    private final long maxDuration;
    private final Instant startTime;

    public IterationTimeBoundedBudget(long initialDelay, long interval, int maxIterations, long maxDuration) {
        this.iterationBudget = new IterationBoundedBudget(initialDelay, interval, maxIterations);
        this.maxDuration = maxDuration;
        this.startTime = Instant.now();
    }

    @Override
    public long initialDelay() {
        return this.iterationBudget.initialDelay();
    }

    @Override
    public long interval() {
        return this.iterationBudget.interval();
    }

    @Override
    public int maxIterations() {
        return this.iterationBudget.maxIterations();
    }

    @Override
    public int iterations() {
        return this.iterationBudget.maxIterations();
    }

    @Override
    public boolean next() {
        if (this.canContinue()) {
            return this.iterationBudget.next();
        }
        return false;
    }

    @Override
    public boolean canContinue() {
        if (!this.iterationBudget.canContinue()) {
            return false;
        }
        return Duration.between(this.startTime, Instant.now()).toMillis() < this.maxDuration;
    }

    @Override
    public long maxDuration() {
        return this.maxDuration;
    }
}

