/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.ObjectHelper;

public final class DefaultExchange
implements Exchange {
    protected final CamelContext context;
    private Map<String, Object> properties;
    private Message in;
    private Message out;
    private Exception exception;
    private String exchangeId;
    private UnitOfWork unitOfWork;
    private ExchangePattern pattern;
    private Endpoint fromEndpoint;
    private String fromRouteId;
    private List<Synchronization> onCompletions;

    public DefaultExchange(CamelContext context) {
        this(context, ExchangePattern.InOnly);
    }

    public DefaultExchange(CamelContext context, ExchangePattern pattern) {
        this.context = context;
        this.pattern = pattern;
    }

    public DefaultExchange(Exchange parent) {
        this(parent.getContext(), parent.getPattern());
        this.fromEndpoint = parent.getFromEndpoint();
        this.fromRouteId = parent.getFromRouteId();
        this.unitOfWork = parent.getUnitOfWork();
    }

    public DefaultExchange(Endpoint fromEndpoint) {
        this(fromEndpoint, ExchangePattern.InOnly);
    }

    public DefaultExchange(Endpoint fromEndpoint, ExchangePattern pattern) {
        this(fromEndpoint.getCamelContext(), pattern);
        this.fromEndpoint = fromEndpoint;
    }

    public String toString() {
        return String.format("Exchange[%s]", this.exchangeId == null ? "" : this.exchangeId);
    }

    public Date getCreated() {
        if (this.hasProperties()) {
            return this.getProperty("CamelCreatedTimestamp", Date.class);
        }
        return null;
    }

    public Exchange copy() {
        DefaultExchange exchange = new DefaultExchange(this);
        exchange.setIn(this.getIn().copy());
        exchange.getIn().setBody(this.getIn().getBody());
        if (this.getIn().hasHeaders()) {
            exchange.getIn().setHeaders(this.safeCopyHeaders(this.getIn().getHeaders()));
        }
        if (this.hasOut()) {
            exchange.setOut(this.getOut().copy());
            exchange.getOut().setBody(this.getOut().getBody());
            if (this.getOut().hasHeaders()) {
                exchange.getOut().setHeaders(this.safeCopyHeaders(this.getOut().getHeaders()));
            }
        }
        exchange.setException(this.getException());
        if (this.hasProperties()) {
            exchange.setProperties(this.safeCopyProperties(this.getProperties()));
        }
        return exchange;
    }

    private Map<String, Object> safeCopyHeaders(Map<String, Object> headers) {
        if (headers == null) {
            return null;
        }
        return this.context.getHeadersMapFactory().newMap(headers);
    }

    private Map<String, Object> safeCopyProperties(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        Map<String, Object> answer = this.createProperties(properties);
        List history = (List)answer.remove("CamelMessageHistory");
        if (history != null) {
            answer.put("CamelMessageHistory", new LinkedList(history));
        }
        return answer;
    }

    public CamelContext getContext() {
        return this.context;
    }

    public Object getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    public Object getProperty(String name, Object defaultValue) {
        Object answer = this.getProperty(name);
        return answer != null ? answer : defaultValue;
    }

    public <T> T getProperty(String name, Class<T> type) {
        Object value = this.getProperty(name);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    public <T> T getProperty(String name, Object defaultValue, Class<T> type) {
        Object value = this.getProperty(name, defaultValue);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    public void setProperty(String name, Object value) {
        if (value != null) {
            this.getProperties().put(name, value);
        } else if (name != null) {
            this.getProperties().remove(name);
        }
    }

    public Object removeProperty(String name) {
        if (!this.hasProperties()) {
            return null;
        }
        return this.getProperties().remove(name);
    }

    public boolean removeProperties(String pattern) {
        return this.removeProperties(pattern, null);
    }

    public boolean removeProperties(String pattern, String ... excludePatterns) {
        if (!this.hasProperties()) {
            return false;
        }
        HashSet<String> toBeRemoved = new HashSet<String>();
        boolean matches = false;
        for (String key : this.properties.keySet()) {
            if (!PatternHelper.matchPattern(key, pattern) || excludePatterns != null && PatternHelper.isExcludePatternMatch(key, excludePatterns)) continue;
            matches = true;
            toBeRemoved.add(key);
        }
        if (!toBeRemoved.isEmpty()) {
            if (toBeRemoved.size() == this.properties.size()) {
                this.properties.clear();
            } else {
                toBeRemoved.forEach(k -> this.properties.remove(k));
            }
        }
        return matches;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = this.createProperties();
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Message getIn() {
        if (this.in == null) {
            this.in = new DefaultMessage(this.getContext());
            this.configureMessage(this.in);
        }
        return this.in;
    }

    public <T> T getIn(Class<T> type) {
        Message in = this.getIn();
        if (type.isInstance(in)) {
            return type.cast(in);
        }
        return (T)this.context.getTypeConverter().convertTo(type, (Exchange)this, (Object)in);
    }

    public void setIn(Message in) {
        this.in = in;
        this.configureMessage(in);
    }

    public Message getOut() {
        if (this.out == null) {
            this.out = this.in instanceof MessageSupport ? ((MessageSupport)this.in).newInstance() : new DefaultMessage(this.getContext());
            this.configureMessage(this.out);
        }
        return this.out;
    }

    public <T> T getOut(Class<T> type) {
        if (!this.hasOut()) {
            return null;
        }
        Message out = this.getOut();
        if (type.isInstance(out)) {
            return type.cast(out);
        }
        return (T)this.context.getTypeConverter().convertTo(type, (Exchange)this, (Object)out);
    }

    public boolean hasOut() {
        return this.out != null;
    }

    public void setOut(Message out) {
        this.out = out;
        this.configureMessage(out);
    }

    public Message getMessage() {
        return this.hasOut() ? this.getOut() : this.getIn();
    }

    public <T> T getMessage(Class<T> type) {
        return this.hasOut() ? this.getOut(type) : this.getIn(type);
    }

    public void setMessage(Message message) {
        if (this.hasOut()) {
            this.setOut(message);
        } else {
            this.setIn(message);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public <T> T getException(Class<T> type) {
        return (T)ObjectHelper.getException(type, (Throwable)this.exception);
    }

    public void setException(Throwable t) {
        this.exception = t == null ? null : (t instanceof Exception ? (Exception)t : CamelExecutionException.wrapCamelExecutionException((Exchange)this, (Throwable)t));
        if (t instanceof InterruptedException) {
            this.setProperty("CamelInterrupted", Boolean.TRUE);
        }
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public Endpoint getFromEndpoint() {
        return this.fromEndpoint;
    }

    public void setFromEndpoint(Endpoint fromEndpoint) {
        this.fromEndpoint = fromEndpoint;
    }

    public String getFromRouteId() {
        return this.fromRouteId;
    }

    public void setFromRouteId(String fromRouteId) {
        this.fromRouteId = fromRouteId;
    }

    public String getExchangeId() {
        if (this.exchangeId == null) {
            this.exchangeId = this.createExchangeId();
        }
        return this.exchangeId;
    }

    public void setExchangeId(String id) {
        this.exchangeId = id;
    }

    public boolean isFailed() {
        return this.exception != null;
    }

    public boolean isTransacted() {
        UnitOfWork uow = this.getUnitOfWork();
        if (uow != null) {
            return uow.isTransacted();
        }
        return false;
    }

    public Boolean isExternalRedelivered() {
        Message msg;
        Boolean answer = null;
        if (this.hasProperties()) {
            answer = this.getProperty("CamelExternalRedelivered", null, Boolean.class);
        }
        if (answer == null && (msg = this.getIn()) instanceof DefaultMessage) {
            answer = ((DefaultMessage)msg).isTransactedRedelivered();
        }
        return answer;
    }

    public boolean isRollbackOnly() {
        return Boolean.TRUE.equals(this.getProperty("CamelRollbackOnly")) || Boolean.TRUE.equals(this.getProperty("CamelRollbackOnlyLast"));
    }

    public UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    public void setUnitOfWork(UnitOfWork unitOfWork) {
        this.unitOfWork = unitOfWork;
        if (unitOfWork != null && this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                unitOfWork.addSynchronization(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        }
    }

    public void addOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork == null) {
            if (this.onCompletions == null) {
                this.onCompletions = new ArrayList<Synchronization>();
            }
            this.onCompletions.add(onCompletion);
        } else {
            this.getUnitOfWork().addSynchronization(onCompletion);
        }
    }

    public boolean containsOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork != null) {
            return this.unitOfWork.containsSynchronization(onCompletion);
        }
        return this.onCompletions != null && this.onCompletions.contains(onCompletion);
    }

    public void handoverCompletions(Exchange target) {
        if (this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                target.addOnCompletion(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        } else if (this.unitOfWork != null) {
            this.unitOfWork.handoverSynchronization(target);
        }
    }

    public List<Synchronization> handoverCompletions() {
        ArrayList<Synchronization> answer = null;
        if (this.onCompletions != null) {
            answer = new ArrayList<Synchronization>(this.onCompletions);
            this.onCompletions.clear();
            this.onCompletions = null;
        }
        return answer;
    }

    protected void configureMessage(Message message) {
        if (message instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)message;
            messageSupport.setExchange(this);
            messageSupport.setCamelContext(this.getContext());
        }
    }

    protected String createExchangeId() {
        return this.context.getUuidGenerator().generateUuid();
    }

    protected Map<String, Object> createProperties() {
        return new ConcurrentHashMap<String, Object>();
    }

    protected Map<String, Object> createProperties(Map<String, Object> properties) {
        return new ConcurrentHashMap<String, Object>(properties);
    }
}

