/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.component.ApiCollection;

public abstract class AbstractApiComponent<E extends Enum<E>, T, S extends ApiCollection<E, T>>
extends DefaultComponent {
    @Metadata(label="advanced")
    protected T configuration;
    protected final S collection;
    protected final Class<E> apiNameClass;

    public AbstractApiComponent(Class<? extends Endpoint> endpointClass, Class<E> apiNameClass, S collection) {
        this.collection = collection;
        this.apiNameClass = apiNameClass;
    }

    public AbstractApiComponent(CamelContext context, Class<? extends Endpoint> endpointClass, Class<E> apiNameClass, S collection) {
        super(context);
        this.collection = collection;
        this.apiNameClass = apiNameClass;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String methodName;
        String apiNameStr;
        String[] pathElements = remaining.split("/");
        switch (pathElements.length) {
            case 1: {
                apiNameStr = "";
                methodName = pathElements[0];
                break;
            }
            case 2: {
                apiNameStr = pathElements[0];
                methodName = pathElements[1];
                break;
            }
            default: {
                throw new CamelException("Invalid URI path [" + remaining + "], must be of the format " + ((ApiCollection)this.collection).getApiNames() + "/<operation-name>");
            }
        }
        try {
            E apiName = this.getApiName(apiNameStr);
            T endpointConfiguration = this.createEndpointConfiguration(apiName);
            Endpoint endpoint = this.createEndpoint(uri, methodName, apiName, endpointConfiguration);
            this.setProperties(endpoint, parameters);
            endpoint.configureProperties(parameters);
            return endpoint;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                throw new CamelException("Invalid URI path prefix [" + remaining + "], must be one of " + ((ApiCollection)this.collection).getApiNames());
            }
            throw e;
        }
    }

    protected abstract E getApiName(String var1) throws IllegalArgumentException;

    protected abstract Endpoint createEndpoint(String var1, String var2, E var3, T var4);

    protected T createEndpointConfiguration(E name) throws Exception {
        HashMap<String, Object> componentProperties = new HashMap<String, Object>();
        if (this.configuration != null) {
            IntrospectionSupport.getProperties(this.configuration, componentProperties, null, false);
        }
        Object endpointConfiguration = ((ApiCollection)this.collection).getEndpointConfiguration(name);
        IntrospectionSupport.setProperties(endpointConfiguration, componentProperties);
        return endpointConfiguration;
    }

    public T getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(T configuration) {
        this.configuration = configuration;
    }
}

