/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvokeOnHeader;
import org.apache.camel.InvokeOnHeaders;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.Processor;
import org.apache.camel.support.BaseSelectorProducer;
import org.apache.camel.support.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderSelectorProducer
extends BaseSelectorProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderSelectorProducer.class);
    private final Supplier<String> headerSupplier;
    private final Supplier<String> defaultHeaderValueSupplier;
    private final Object target;
    private Map<String, Processor> handlers;

    public HeaderSelectorProducer(Endpoint endpoint, Supplier<String> headerSupplier) {
        this(endpoint, headerSupplier, () -> null, null);
    }

    public HeaderSelectorProducer(Endpoint endpoint, Supplier<String> headerSupplier, boolean caseSensitive) {
        this(endpoint, headerSupplier, () -> null, null, caseSensitive);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header) {
        this(endpoint, () -> header, () -> null, null);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, boolean caseSensitive) {
        this(endpoint, () -> header, () -> null, null, caseSensitive);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, Object target) {
        this(endpoint, () -> header, () -> null, target);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, Object target, boolean caseSensitive) {
        this(endpoint, () -> header, () -> null, target, caseSensitive);
    }

    public HeaderSelectorProducer(Endpoint endpoint, Supplier<String> headerSupplier, Object target) {
        this(endpoint, headerSupplier, () -> null, target);
    }

    public HeaderSelectorProducer(Endpoint endpoint, Supplier<String> headerSupplier, Object target, boolean caseSensitive) {
        this(endpoint, headerSupplier, () -> null, target, caseSensitive);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, String defaultHeaderValue) {
        this(endpoint, () -> header, () -> defaultHeaderValue, null);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, String defaultHeaderValue, boolean caseSensitive) {
        this(endpoint, () -> header, () -> defaultHeaderValue, null, caseSensitive);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, Supplier<String> defaultHeaderValueSupplier) {
        this(endpoint, () -> header, defaultHeaderValueSupplier, null);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, Supplier<String> defaultHeaderValueSupplier, boolean caseSensitive) {
        this(endpoint, () -> header, defaultHeaderValueSupplier, null, caseSensitive);
    }

    public HeaderSelectorProducer(Endpoint endpoint, Supplier<String> headerSupplier, Supplier<String> defaultHeaderValueSupplier) {
        this(endpoint, headerSupplier, defaultHeaderValueSupplier, null);
    }

    public HeaderSelectorProducer(Endpoint endpoint, Supplier<String> headerSupplier, Supplier<String> defaultHeaderValueSupplier, boolean caseSensitive) {
        this(endpoint, headerSupplier, defaultHeaderValueSupplier, null, caseSensitive);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, String defaultHeaderValue, Object target) {
        this(endpoint, () -> header, () -> defaultHeaderValue, target);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, String defaultHeaderValue, Object target, boolean caseSensitive) {
        this(endpoint, () -> header, () -> defaultHeaderValue, target, caseSensitive);
    }

    public HeaderSelectorProducer(Endpoint endpoint, Supplier<String> headerSupplier, Supplier<String> defaultHeaderValueSupplier, Object target) {
        this(endpoint, headerSupplier, defaultHeaderValueSupplier, target, true);
    }

    public HeaderSelectorProducer(Endpoint endpoint, Supplier<String> headerSupplier, Supplier<String> defaultHeaderValueSupplier, Object target, boolean caseSensitive) {
        super(endpoint);
        this.headerSupplier = (Supplier)org.apache.camel.util.ObjectHelper.notNull(headerSupplier, (String)"headerSupplier");
        this.defaultHeaderValueSupplier = (Supplier)org.apache.camel.util.ObjectHelper.notNull(defaultHeaderValueSupplier, (String)"defaultHeaderValueSupplier");
        this.target = target != null ? target : this;
        this.handlers = caseSensitive ? new HashMap() : new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }

    @Override
    protected void doStart() throws Exception {
        for (Method method : this.target.getClass().getDeclaredMethods()) {
            InvokeOnHeaders annotation = method.getAnnotation(InvokeOnHeaders.class);
            if (annotation != null) {
                for (InvokeOnHeader processor : annotation.value()) {
                    this.bind(processor, method);
                }
                continue;
            }
            this.bind(method.getAnnotation(InvokeOnHeader.class), method);
        }
        this.handlers = Collections.unmodifiableMap(this.handlers);
        super.doStart();
    }

    @Override
    protected Processor getProcessor(Exchange exchange) throws Exception {
        String header = this.headerSupplier.get();
        String action = (String)exchange.getIn().getHeader(header, String.class);
        if (action == null) {
            action = this.defaultHeaderValueSupplier.get();
        }
        if (action == null) {
            throw new NoSuchHeaderException(exchange, header, String.class);
        }
        return this.handlers.get(action);
    }

    @Override
    protected void onMissingProcessor(Exchange exchange) throws Exception {
        throw new IllegalStateException("Unsupported operation " + exchange.getIn().getHeader(this.headerSupplier.get()));
    }

    protected final void bind(String key, Processor processor) {
        if (this.handlers.containsKey(key)) {
            LOGGER.warn("A processor is already set for action {}", (Object)key);
        }
        this.handlers.put(key, processor);
    }

    private void bind(InvokeOnHeader handler, Method method) {
        if (handler != null && method.getParameterCount() == 1) {
            Class<?> type = method.getParameterTypes()[0];
            LOGGER.debug("bind key={}, class={}, method={}, type={}", new Object[]{handler.value(), ((Object)((Object)this)).getClass(), method.getName(), type});
            if (Message.class.isAssignableFrom(type)) {
                this.bind(handler.value(), e -> ObjectHelper.invokeMethodSafe(method, this.target, e.getIn()));
            } else {
                this.bind(handler.value(), e -> ObjectHelper.invokeMethodSafe(method, this.target, e));
            }
        }
    }
}

