/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;

public class DefaultMessageHistory
implements MessageHistory {
    private final String routeId;
    private final NamedNode node;
    private final String nodeId;
    private final long timestamp;
    private long elapsed;

    public DefaultMessageHistory(String routeId, NamedNode node, long timestamp) {
        this.routeId = routeId;
        this.node = node;
        this.nodeId = node.getId();
        this.timestamp = timestamp;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public NamedNode getNode() {
        return this.node;
    }

    public long getTime() {
        return this.timestamp;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public void nodeProcessingDone() {
        if (this.timestamp > 0L) {
            this.elapsed = System.currentTimeMillis() - this.timestamp;
        }
    }

    public String toString() {
        return "DefaultMessageHistory[routeId=" + this.routeId + ", node=" + this.nodeId + ']';
    }
}

