/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.BytesSource;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.StringSource;
import org.apache.camel.converter.stream.ByteArrayInputStreamCache;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.ReaderCache;
import org.apache.camel.converter.stream.SourceCache;
import org.apache.camel.converter.stream.StreamSourceCache;
import org.apache.camel.util.IOHelper;

@Converter(loader=true)
public final class StreamCacheConverter {
    private StreamCacheConverter() {
    }

    @Converter
    public static StreamCache convertToStreamCache(StreamSource source, Exchange exchange) throws IOException {
        return new StreamSourceCache(source, exchange);
    }

    @Converter
    public static StreamCache convertToStreamCache(StringSource source) {
        return null;
    }

    @Converter
    public static StreamCache convertToStreamCache(BytesSource source) {
        return null;
    }

    @Converter
    public static StreamCache convertToStreamCache(SAXSource source, Exchange exchange) throws TransformerException {
        String data = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, (Object)source);
        return new SourceCache(data);
    }

    @Converter
    public static StreamCache convertToStreamCache(ByteArrayInputStream stream, Exchange exchange) throws IOException {
        return new ByteArrayInputStreamCache(stream);
    }

    @Converter
    public static StreamCache convertToStreamCache(InputStream stream, Exchange exchange) throws IOException {
        CachedOutputStream cos = new CachedOutputStream(exchange);
        IOHelper.copyAndCloseInput((InputStream)stream, (OutputStream)cos);
        return cos.newStreamCache();
    }

    @Converter
    public static StreamCache convertToStreamCache(CachedOutputStream cos, Exchange exchange) throws IOException {
        return cos.newStreamCache();
    }

    @Converter
    public static StreamCache convertToStreamCache(Reader reader, Exchange exchange) throws IOException {
        String data = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, (Object)reader);
        return new ReaderCache(data);
    }

    @Converter
    public static Serializable convertToSerializable(StreamCache cache, Exchange exchange) throws IOException {
        byte[] data = StreamCacheConverter.convertToByteArray(cache, exchange);
        return new BytesSource(data);
    }

    @Converter
    public static byte[] convertToByteArray(StreamCache cache, Exchange exchange) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        cache.writeTo((OutputStream)os);
        return os.toByteArray();
    }

    @Converter
    public static ByteBuffer convertToByteBuffer(StreamCache cache, Exchange exchange) throws IOException {
        byte[] array = StreamCacheConverter.convertToByteArray(cache, exchange);
        return ByteBuffer.wrap(array);
    }
}

