package org.apache.camel.converter.stream;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

@SuppressWarnings("unchecked")
public class StreamCacheConverterLoader implements TypeConverterLoader {


    static abstract class BaseTypeConverter extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        @Override
        public boolean allowNull() {
            return allowNull;
        }

        @Override
        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T) doConvert(exchange, value);
            } catch (TypeConversionException e) {
                throw e;
            } catch (Exception e) {
                throw new TypeConversionException(value, type, e);
            }
        }
        protected abstract Object doConvert(Exchange exchange, Object value) throws Exception;
    };

    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap<>(11);

    public StreamCacheConverterLoader() {
    }

    private void registerConverters() {
        converters.put(byte[].class, org.apache.camel.StreamCache.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToByteArray((org.apache.camel.StreamCache) value, exchange);
            }
        });
        converters.put(java.io.Serializable.class, org.apache.camel.StreamCache.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToSerializable((org.apache.camel.StreamCache) value, exchange);
            }
        });
        converters.put(java.nio.ByteBuffer.class, org.apache.camel.StreamCache.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToByteBuffer((org.apache.camel.StreamCache) value, exchange);
            }
        });
        converters.put(org.apache.camel.StreamCache.class, java.io.ByteArrayInputStream.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((java.io.ByteArrayInputStream) value, exchange);
            }
        });
        converters.put(org.apache.camel.StreamCache.class, java.io.InputStream.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((java.io.InputStream) value, exchange);
            }
        });
        converters.put(org.apache.camel.StreamCache.class, java.io.Reader.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((java.io.Reader) value, exchange);
            }
        });
        converters.put(org.apache.camel.StreamCache.class, javax.xml.transform.sax.SAXSource.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((javax.xml.transform.sax.SAXSource) value, exchange);
            }
        });
        converters.put(org.apache.camel.StreamCache.class, org.apache.camel.BytesSource.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((org.apache.camel.BytesSource) value);
            }
        });
        converters.put(org.apache.camel.StreamCache.class, org.apache.camel.StringSource.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((org.apache.camel.StringSource) value);
            }
        });
        converters.put(org.apache.camel.StreamCache.class, javax.xml.transform.stream.StreamSource.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((javax.xml.transform.stream.StreamSource) value, exchange);
            }
        });
        converters.put(org.apache.camel.StreamCache.class, org.apache.camel.converter.stream.CachedOutputStream.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((org.apache.camel.converter.stream.CachedOutputStream) value, exchange);
            }
        });
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registerConverters();
        converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, c));
    }

}
