/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.support.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiMethodPropertiesHelper<C> {
    protected static final Logger LOG = LoggerFactory.getLogger(ApiMethodPropertiesHelper.class);
    protected final Set<String> componentConfigFields = new HashSet<String>();
    protected final Class<?> componentConfigClass;
    protected final String propertyPrefix;
    private final int prefixLength;
    private final String camelCasePrefix;

    protected ApiMethodPropertiesHelper(Class<C> componentConfiguration, String propertyPrefix) {
        this.componentConfigClass = componentConfiguration;
        this.propertyPrefix = propertyPrefix;
        this.prefixLength = propertyPrefix.length();
        this.camelCasePrefix = !Character.isLetterOrDigit(propertyPrefix.charAt(this.prefixLength - 1)) ? propertyPrefix.substring(0, this.prefixLength - 1) : null;
        for (Field field : componentConfiguration.getDeclaredFields()) {
            this.componentConfigFields.add(field.getName());
        }
    }

    public Map<String, Object> getExchangeProperties(Exchange exchange, Map<String, Object> properties) {
        int nProperties = 0;
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(this.propertyPrefix)) {
                properties.put(key.substring(this.prefixLength), entry.getValue());
                ++nProperties;
                continue;
            }
            if (this.camelCasePrefix == null || !key.startsWith(this.camelCasePrefix)) continue;
            String propertyName = String.valueOf(Character.toLowerCase(key.charAt(this.prefixLength - 1))) + key.substring(this.prefixLength);
            properties.put(propertyName, entry.getValue());
            ++nProperties;
        }
        LOG.debug("Found {} properties in exchange", (Object)nProperties);
        return properties;
    }

    public void getEndpointProperties(Object endpointConfiguration, Map<String, Object> properties) {
        Set<String> names = null;
        if (IntrospectionSupport.getProperties(endpointConfiguration, properties, null, false)) {
            names = properties.keySet();
            names.removeAll(this.componentConfigFields);
        }
        LOG.debug("Found endpoint properties {}", names);
    }

    public Set<String> getEndpointPropertyNames(Object endpointConfiguration) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.getEndpointProperties(endpointConfiguration, properties);
        return Collections.unmodifiableSet(properties.keySet());
    }

    public Set<String> getValidEndpointProperties(Object endpointConfiguration) {
        HashSet<String> fields = new HashSet<String>();
        for (Field field : endpointConfiguration.getClass().getDeclaredFields()) {
            fields.add(field.getName());
        }
        return Collections.unmodifiableSet(fields);
    }
}

