/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored.template.ast;

import java.util.Map;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.sql.stored.template.ast.ParseRuntimeException;
import org.apache.camel.component.sql.stored.template.ast.ValueExtractor;
import org.apache.camel.component.sql.stored.template.generated.Token;

public class InParameter {
    private final String name;
    private final String typeName;
    private final int sqlType;
    private final Integer scale;
    private ValueExtractor valueExtractor;

    public InParameter(String name, int sqlType, Token valueSrcToken, Integer scale, String typeName) {
        this.name = name;
        this.sqlType = sqlType;
        this.parseValueExpression(valueSrcToken);
        this.scale = scale;
        this.typeName = typeName;
        if (this.scale != null && this.typeName != null) {
            throw new ParseRuntimeException(String.format("Both scale=%s and typeName=%s cannot be set", this.scale, this.typeName));
        }
    }

    private void parseValueExpression(Token valueSrcToken) {
        if (14 == valueSrcToken.kind) {
            Expression exp = ExpressionBuilder.simpleExpression((String)valueSrcToken.toString());
            this.valueExtractor = (exchange, container) -> exp.evaluate(exchange, Object.class);
        } else if (15 == valueSrcToken.kind) {
            String mapKey = valueSrcToken.toString().substring(2);
            this.valueExtractor = (exchange, container) -> ((Map)container).get(mapKey);
        }
    }

    public Integer getScale() {
        return this.scale;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public ValueExtractor getValueExtractor() {
        return this.valueExtractor;
    }
}

