/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.main.DefaultConfigurationConfigurer;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.apache.camel.model.Model;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.boot.CamelConfigurationProperties;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.spring.boot.CamelSpringBootApplicationController;
import org.apache.camel.spring.boot.FatJarPackageScanClassResolver;
import org.apache.camel.spring.boot.FilePropertySource;
import org.apache.camel.spring.boot.RoutesCollector;
import org.apache.camel.spring.boot.SpringBootCamelContext;
import org.apache.camel.spring.boot.SpringBootXmlCamelContextConfigurer;
import org.apache.camel.spring.boot.SpringPropertiesParser;
import org.apache.camel.spring.boot.TypeConversionConfiguration;
import org.apache.camel.spring.spi.ApplicationContextBeanRepository;
import org.apache.camel.spring.spi.XmlCamelContextConfigurer;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.OrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@Configuration
@EnableConfigurationProperties(value={CamelConfigurationProperties.class})
@Import(value={TypeConversionConfiguration.class})
public class CamelAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CamelAutoConfiguration.class);

    @Bean(name={"xmlCamelContextConfigurer"})
    XmlCamelContextConfigurer springBootCamelContextConfigurer() {
        return new SpringBootXmlCamelContextConfigurer();
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={CamelContext.class})
    CamelContext camelContext(ApplicationContext applicationContext, CamelConfigurationProperties config) throws Exception {
        SpringBootCamelContext camelContext = new SpringBootCamelContext(applicationContext, config.isWarnOnEarlyShutdown());
        return CamelAutoConfiguration.doConfigureCamelContext(applicationContext, (CamelContext)camelContext, config);
    }

    static CamelContext doConfigureCamelContext(ApplicationContext applicationContext, CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        MutablePropertySources sources;
        Environment env;
        camelContext.init();
        Map repositories = applicationContext.getBeansOfType(BeanRepository.class);
        if (!repositories.isEmpty()) {
            ArrayList<Object> reps = new ArrayList<Object>();
            reps.add(new ApplicationContextBeanRepository(applicationContext));
            reps.addAll(repositories.values());
            OrderComparator.sort(reps);
            ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).setRegistry((Registry)new DefaultRegistry(reps));
        }
        if (ObjectHelper.isNotEmpty((Object)config.getFileConfigurations()) && (env = applicationContext.getEnvironment()) instanceof ConfigurableEnvironment && (sources = ((ConfigurableEnvironment)env).getPropertySources()) != null && !sources.contains("camel-file-configuration")) {
            sources.addFirst((PropertySource)new FilePropertySource("camel-file-configuration", applicationContext, config.getFileConfigurations()));
        }
        ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).setPackageScanClassResolver((PackageScanClassResolver)new FatJarPackageScanClassResolver());
        if (config.getRouteFilterIncludePattern() != null || config.getRouteFilterExcludePattern() != null) {
            LOG.info("Route filtering pattern: include={}, exclude={}", (Object)config.getRouteFilterIncludePattern(), (Object)config.getRouteFilterExcludePattern());
            ((Model)camelContext.getExtension(Model.class)).setRouteFilterPattern(config.getRouteFilterIncludePattern(), config.getRouteFilterExcludePattern());
        }
        DefaultConfigurationConfigurer.configure((CamelContext)camelContext, (DefaultConfigurationProperties)config);
        DefaultConfigurationConfigurer.afterPropertiesSet((CamelContext)camelContext);
        return camelContext;
    }

    @Bean
    CamelSpringBootApplicationController applicationController(ApplicationContext applicationContext, CamelContext camelContext) {
        return new CamelSpringBootApplicationController(applicationContext, camelContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={RoutesCollector.class})
    RoutesCollector routesCollector(ApplicationContext applicationContext, CamelConfigurationProperties config) {
        Collection configurations = applicationContext.getBeansOfType(CamelContextConfiguration.class).values();
        return new RoutesCollector(applicationContext, new ArrayList<CamelContextConfiguration>(configurations), config);
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={FluentProducerTemplate.class})
    @Lazy
    FluentProducerTemplate fluentProducerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        FluentProducerTemplate fluentProducerTemplate = camelContext.createFluentProducerTemplate(config.getProducerTemplateCacheSize());
        camelContext.addService((Object)fluentProducerTemplate);
        return fluentProducerTemplate;
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={ProducerTemplate.class})
    @Lazy
    ProducerTemplate producerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        ProducerTemplate producerTemplate = camelContext.createProducerTemplate(config.getProducerTemplateCacheSize());
        camelContext.addService((Object)producerTemplate);
        return producerTemplate;
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={ConsumerTemplate.class})
    @Lazy
    ConsumerTemplate consumerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        ConsumerTemplate consumerTemplate = camelContext.createConsumerTemplate(config.getConsumerTemplateCacheSize());
        camelContext.addService((Object)consumerTemplate);
        return consumerTemplate;
    }

    @Bean
    PropertiesParser propertiesParser() {
        return new SpringPropertiesParser();
    }

    @Bean(destroyMethod="")
    PropertiesComponent properties(CamelContext camelContext, PropertiesParser parser) {
        if (camelContext.hasComponent("properties") != null) {
            return (PropertiesComponent)camelContext.getComponent("properties", PropertiesComponent.class);
        }
        PropertiesComponent pc = new PropertiesComponent();
        pc.setPropertiesParser(parser);
        return pc;
    }

    @Bean
    CamelBeanPostProcessor camelBeanPostProcessor(ApplicationContext applicationContext) {
        CamelBeanPostProcessor processor = new CamelBeanPostProcessor();
        processor.setApplicationContext(applicationContext);
        return processor;
    }
}

