/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.io.FileNotFoundException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.main.MainDurationEventNotifier;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spring.boot.CamelConfigurationProperties;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.spring.boot.CamelMainRunController;
import org.apache.camel.spring.boot.CamelSpringBootInitializationException;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;
import org.springframework.util.AntPathMatcher;

public class RoutesCollector
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(RoutesCollector.class);
    private final ApplicationContext applicationContext;
    private final List<CamelContextConfiguration> camelContextConfigurations;
    private final CamelConfigurationProperties configurationProperties;

    public RoutesCollector(ApplicationContext applicationContext, List<CamelContextConfiguration> camelContextConfigurations, CamelConfigurationProperties configurationProperties) {
        this.applicationContext = applicationContext;
        this.camelContextConfigurations = new ArrayList<CamelContextConfiguration>(camelContextConfigurations);
        this.configurationProperties = configurationProperties;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        if (this.applicationContext.equals(applicationContext)) {
            CamelContext camelContext = (CamelContext)event.getApplicationContext().getBean(CamelContext.class);
            if (camelContext.getStatus().isStopped()) {
                LOG.debug("Post-processing CamelContext bean: {}", (Object)camelContext.getName());
                AntPathMatcher matcher = new AntPathMatcher();
                for (RoutesBuilder routesBuilder : applicationContext.getBeansOfType(RoutesBuilder.class, this.configurationProperties.isIncludeNonSingletons(), true).values()) {
                    String[] parts;
                    boolean match;
                    boolean abs = Modifier.isAbstract(routesBuilder.getClass().getModifiers());
                    if (abs) continue;
                    String name = routesBuilder.getClass().getName();
                    name = name.replace('.', '/');
                    String exclude = this.configurationProperties.getJavaRoutesExcludePattern();
                    String include = this.configurationProperties.getJavaRoutesIncludePattern();
                    boolean bl = match = !"false".equals(include);
                    if (match && ObjectHelper.isNotEmpty((Object)exclude)) {
                        for (String part : parts = exclude.split(",")) {
                            match = !matcher.match(part, name);
                            LOG.trace("Java RoutesBuilder: {} exclude filter: {} -> {}", new Object[]{name, part, match});
                            if (!match) break;
                        }
                    }
                    if (match && ObjectHelper.isNotEmpty((Object)include)) {
                        for (String part : parts = include.split(",")) {
                            match = matcher.match(part, name);
                            LOG.trace("Java RoutesBuilder: {} include filter: {} -> {}", new Object[]{name, part, match});
                            if (match) break;
                        }
                    }
                    LOG.debug("Java RoutesBuilder: {} accepted by include/exclude filter: {}", (Object)name, (Object)match);
                    if (!match) continue;
                    try {
                        LOG.debug("Injecting following route into the CamelContext: {}", (Object)routesBuilder);
                        camelContext.addRoutes(routesBuilder);
                    }
                    catch (Exception e) {
                        throw new CamelSpringBootInitializationException(e);
                    }
                }
                try {
                    boolean scanRests;
                    boolean scan;
                    boolean bl = scan = !this.configurationProperties.getXmlRoutes().equals("false");
                    if (scan) {
                        this.loadXmlRoutes(applicationContext, camelContext, this.configurationProperties.getXmlRoutes());
                    }
                    boolean bl2 = scanRests = !this.configurationProperties.getXmlRests().equals("false");
                    if (scanRests) {
                        this.loadXmlRests(applicationContext, camelContext, this.configurationProperties.getXmlRests());
                    }
                    for (CamelContextConfiguration camelContextConfiguration : this.camelContextConfigurations) {
                        LOG.debug("CamelContextConfiguration found. Invoking beforeApplicationStart: {}", (Object)camelContextConfiguration);
                        camelContextConfiguration.beforeApplicationStart(camelContext);
                    }
                    if (this.configurationProperties.isMainRunController()) {
                        CamelMainRunController controller = new CamelMainRunController(applicationContext, camelContext);
                        if (this.configurationProperties.getDurationMaxMessages() > 0 || this.configurationProperties.getDurationMaxIdleSeconds() > 0) {
                            if (this.configurationProperties.getDurationMaxMessages() > 0) {
                                LOG.info("CamelSpringBoot will terminate after processing {} messages", (Object)this.configurationProperties.getDurationMaxMessages());
                            }
                            if (this.configurationProperties.getDurationMaxIdleSeconds() > 0) {
                                LOG.info("CamelSpringBoot will terminate after being idle for more {} seconds", (Object)this.configurationProperties.getDurationMaxIdleSeconds());
                            }
                            MainDurationEventNotifier notifier = new MainDurationEventNotifier(camelContext, this.configurationProperties.getDurationMaxMessages(), (long)this.configurationProperties.getDurationMaxIdleSeconds(), controller.getCompleted(), controller.getLatch(), true);
                            ServiceHelper.startService((Object)notifier);
                            camelContext.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
                        }
                        if (this.configurationProperties.getDurationMaxSeconds() > 0) {
                            LOG.info("CamelSpringBoot will terminate after {} seconds", (Object)this.configurationProperties.getDurationMaxSeconds());
                            this.terminateMainControllerAfter(camelContext, this.configurationProperties.getDurationMaxSeconds(), controller.getCompleted(), controller.getLatch());
                        }
                        LOG.info("Starting CamelMainRunController to ensure the main thread keeps running");
                        controller.start();
                    } else {
                        if (applicationContext instanceof ConfigurableApplicationContext) {
                            ConfigurableApplicationContext cac = (ConfigurableApplicationContext)applicationContext;
                            if (this.configurationProperties.getDurationMaxSeconds() > 0) {
                                LOG.info("CamelSpringBoot will terminate after {} seconds", (Object)this.configurationProperties.getDurationMaxSeconds());
                                this.terminateApplicationContext(cac, camelContext, this.configurationProperties.getDurationMaxSeconds());
                            }
                            if (this.configurationProperties.getDurationMaxMessages() > 0 || this.configurationProperties.getDurationMaxIdleSeconds() > 0) {
                                if (this.configurationProperties.getDurationMaxMessages() > 0) {
                                    LOG.info("CamelSpringBoot will terminate after processing {} messages", (Object)this.configurationProperties.getDurationMaxMessages());
                                }
                                if (this.configurationProperties.getDurationMaxIdleSeconds() > 0) {
                                    LOG.info("CamelSpringBoot will terminate after being idle for more {} seconds", (Object)this.configurationProperties.getDurationMaxIdleSeconds());
                                }
                                AtomicBoolean completed = new AtomicBoolean();
                                CountDownLatch latch = new CountDownLatch(1);
                                MainDurationEventNotifier notifier = new MainDurationEventNotifier(camelContext, this.configurationProperties.getDurationMaxMessages(), (long)this.configurationProperties.getDurationMaxIdleSeconds(), completed, latch, false);
                                ServiceHelper.startService((Object)notifier);
                                camelContext.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
                                this.terminateApplicationContext(cac, camelContext, latch);
                            }
                        }
                        this.maybeStart(camelContext);
                    }
                    for (CamelContextConfiguration camelContextConfiguration : this.camelContextConfigurations) {
                        LOG.debug("CamelContextConfiguration found. Invoking afterApplicationStart: {}", (Object)camelContextConfiguration);
                        camelContextConfiguration.afterApplicationStart(camelContext);
                    }
                }
                catch (Exception e) {
                    throw new CamelSpringBootInitializationException(e);
                }
            } else {
                LOG.debug("Camel already started, not adding routes.");
            }
        } else {
            LOG.debug("Ignore ContextRefreshedEvent: {}", (Object)event);
        }
    }

    private void maybeStart(CamelContext camelContext) throws Exception {
        boolean skip = "true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"));
        if (skip) {
            LOG.info("Skipping starting CamelContext as system property skipStartingCamelContext is set to be true.");
        } else {
            camelContext.start();
        }
    }

    private void loadXmlRoutes(ApplicationContext applicationContext, CamelContext camelContext, String directory) throws Exception {
        LOG.info("Loading additional Camel XML routes from: {}", (Object)directory);
        try {
            Resource[] xmlRoutes;
            for (Resource xmlRoute : xmlRoutes = applicationContext.getResources(directory)) {
                LOG.debug("Found XML route: {}", (Object)xmlRoute);
                RoutesDefinition xmlDefinition = camelContext.loadRoutesDefinition(xmlRoute.getInputStream());
                camelContext.addRouteDefinitions((Collection)xmlDefinition.getRoutes());
            }
        }
        catch (FileNotFoundException e) {
            LOG.debug("No XML routes found in {}. Skipping XML routes detection.", (Object)directory);
        }
    }

    private void loadXmlRests(ApplicationContext applicationContext, CamelContext camelContext, String directory) {
        LOG.info("Loading additional Camel XML rests from: {}", (Object)directory);
        try {
            Resource[] xmlRests;
            for (Resource xmlRest : xmlRests = applicationContext.getResources(directory)) {
                RestsDefinition xmlDefinitions = camelContext.loadRestsDefinition(xmlRest.getInputStream());
                camelContext.addRestDefinitions((Collection)xmlDefinitions.getRests());
                for (RestDefinition xmlDefinition : xmlDefinitions.getRests()) {
                    List routeDefinitions = xmlDefinition.asRouteDefinition(camelContext);
                    camelContext.addRouteDefinitions((Collection)routeDefinitions);
                }
            }
        }
        catch (FileNotFoundException e) {
            LOG.debug("No XML rests found in {}. Skipping XML rests detection.", (Object)directory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void terminateMainControllerAfter(CamelContext camelContext, int seconds, AtomicBoolean completed, CountDownLatch latch) {
        ScheduledExecutorService executorService = camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "CamelSpringBootTerminateTask");
        Runnable task = () -> {
            LOG.info("CamelSpringBoot triggering shutdown of the JVM.");
            try {
                camelContext.stop();
            }
            catch (Throwable e) {
                LOG.warn("Error during stopping CamelContext", e);
            }
            finally {
                completed.set(true);
                latch.countDown();
            }
        };
        executorService.schedule(task, (long)seconds, TimeUnit.SECONDS);
    }

    private void terminateApplicationContext(ConfigurableApplicationContext applicationContext, CamelContext camelContext, int seconds) {
        ScheduledExecutorService executorService = camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "CamelSpringBootTerminateTask");
        Runnable task = () -> {
            LOG.info("CamelSpringBoot triggering shutdown of the JVM.");
            new Thread(() -> ((ConfigurableApplicationContext)applicationContext).close()).start();
        };
        executorService.schedule(task, (long)seconds, TimeUnit.SECONDS);
    }

    private void terminateApplicationContext(ConfigurableApplicationContext applicationContext, CamelContext camelContext, CountDownLatch latch) {
        ExecutorService executorService = camelContext.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "CamelSpringBootTerminateTask");
        Runnable task = () -> {
            try {
                latch.await();
                LOG.info("CamelSpringBoot triggering shutdown of the JVM.");
                new Thread(() -> ((ConfigurableApplicationContext)applicationContext).close()).start();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
        executorService.submit(task);
    }
}

