/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.soap.name;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchema;
import jakarta.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.camel.dataformat.soap.name.ElementNameStrategy;
import org.apache.camel.util.ObjectHelper;

public class TypeNameStrategy
implements ElementNameStrategy {
    @Override
    public QName findQNameForSoapActionOrType(String soapAction, Class<?> type) {
        XmlRootElement root;
        String localName;
        XmlSchema xmlSchema;
        XmlType xmlType = type.getAnnotation(XmlType.class);
        if (xmlType == null || xmlType.name() == null) {
            throw new RuntimeException("The type " + type.getName() + " needs to have an XmlType annotation with name");
        }
        String nameSpace = xmlType.namespace();
        if ("##default".equals(nameSpace) && (xmlSchema = type.getPackage().getAnnotation(XmlSchema.class)) != null) {
            nameSpace = xmlSchema.namespace();
        }
        if (ObjectHelper.isEmpty((String)(localName = xmlType.name())) && (root = type.getAnnotation(XmlRootElement.class)) != null) {
            localName = root.name();
        }
        return new QName(nameSpace, localName);
    }

    @Override
    public Class<? extends Exception> findExceptionForFaultName(QName faultName) {
        throw new UnsupportedOperationException("Exception lookup is not supported for TypeNameStrategy");
    }

    @Override
    public Class<? extends Exception> findExceptionForSoapActionAndFaultName(String soapAction, QName faultName) {
        throw new UnsupportedOperationException("Exception lookup is not supported for TypeNameStrategy");
    }
}

