/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;

public final class SpringBootHelper {
    public static final String STARTER_SUFFIX = "-starter";

    private SpringBootHelper() {
    }

    public static File starterSrcDir(File baseDir, String artifactId) {
        return new File(SpringBootHelper.starterDir(baseDir, artifactId), "src/main/java");
    }

    public static File starterResourceDir(File baseDir, String artifactId) {
        return new File(SpringBootHelper.starterDir(baseDir, artifactId), "src/main/resources");
    }

    public static File starterDir(File baseDir, String artifactId) {
        String starterName = artifactId + STARTER_SUFFIX;
        File allStartersDir = SpringBootHelper.allStartersDir(baseDir);
        File starterDir = new File(allStartersDir, starterName);
        return starterDir;
    }

    public static File allStartersDir(File baseDir) {
        File allStartersDir = new File(SpringBootHelper.camelProjectRoot(baseDir, "platforms"), "platforms/spring-boot/components-starter");
        return allStartersDir;
    }

    public static File camelProjectRoot(File baseDir, String expectedDirName) {
        try {
            File[] names;
            File root;
            for (root = baseDir.getCanonicalFile(); root != null && ((names = root.listFiles(pathname -> pathname.getName().equals(expectedDirName))) == null || names.length != 1); root = root.getParentFile()) {
            }
            if (root == null) {
                throw new IllegalStateException("Cannot find Apache Camel project root directory");
            }
            return root;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while getting directory", e);
        }
    }
}

