/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.model;

import org.apache.camel.maven.packaging.StringHelper;

public class OtherOptionModel {
    private String name;
    private String displayName;
    private String kind;
    private String group;
    private String required;
    private String type;
    private String javaType;
    private String deprecated;
    private String secret;
    private String description;
    private String defaultValue;
    private String enums;
    private boolean newGroup;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getRequired() {
        return this.required;
    }

    public void setRequired(String required) {
        this.required = required;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(String deprecated) {
        this.deprecated = deprecated;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getEnums() {
        return this.enums;
    }

    public void setEnums(String enums) {
        this.enums = enums;
    }

    public boolean isNewGroup() {
        return this.newGroup;
    }

    public void setNewGroup(boolean newGroup) {
        this.newGroup = newGroup;
    }

    public String getShortJavaType() {
        return this.getShortJavaType(40);
    }

    public String getShortJavaType(int watermark) {
        if (this.javaType.startsWith("java.util.Map")) {
            return "Map";
        }
        if (this.javaType.startsWith("java.util.Set")) {
            return "Set";
        }
        if (this.javaType.startsWith("java.util.List")) {
            return "List";
        }
        String text = this.javaType;
        int pos = text.lastIndexOf(".");
        if (pos != -1) {
            text = text.substring(pos + 1);
        }
        if ("object".equals(this.type)) {
            text = StringHelper.wrapCamelCaseWords(text, watermark, " ");
        }
        return text;
    }

    public String getShortGroup() {
        if (this.group.endsWith(" (advanced)")) {
            return this.group.substring(0, this.group.length() - 11);
        }
        return this.group;
    }

    public String getShortDefaultValue(int watermark) {
        if (this.defaultValue.isEmpty()) {
            return "";
        }
        String text = this.defaultValue;
        if (text.endsWith("<T>")) {
            text = text.substring(0, text.length() - 3);
        } else if (text.endsWith("<T>>")) {
            text = text.substring(0, text.length() - 4);
        }
        if ("AUTO_ACKNOWLEDGE".equals(text)) {
            return "AUTO_ ACKNOWLEDGE";
        }
        return text;
    }

    public String getShortName(int watermark) {
        String text = StringHelper.wrapCamelCaseWords(this.name, watermark, " ");
        return Character.toLowerCase(text.charAt(0)) + text.substring(1);
    }
}

