/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class PackageModelMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File buildDir;
    protected File outDir;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File camelMetaDir = new File(this.outDir, "META-INF/services/org/apache/camel/");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        if (this.buildDir != null && this.buildDir.isDirectory()) {
            File target = new File(this.buildDir, "classes/org/apache/camel/model");
            PackageHelper.findJsonFiles(target, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        }
        File outFile = new File(camelMetaDir, "model.properties");
        try {
            camelMetaDir.mkdirs();
            Properties properties = new Properties();
            properties.store(new FileWriter(outFile), "Generated by camel-package-maven-plugin");
            ArrayList<String> models = new ArrayList<String>();
            for (File file : jsonFiles) {
                String name = file.getName();
                if (!name.endsWith(".json")) continue;
                String modelName = name.substring(0, name.length() - 5);
                models.add(modelName);
            }
            Collections.sort(models);
            FileOutputStream fos = new FileOutputStream(outFile, true);
            for (String name : models) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
            }
            fos.close();
            this.getLog().info((CharSequence)("Generated " + outFile + " containing " + models.size() + " Camel models"));
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + outFile);
        }
    }
}

