/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JSonSchemaHelper {
    private static final Pattern PATTERN = Pattern.compile("\"(.+?)\"|\\[(.+)\\]|(true|false)|(-?\\d+\\.?\\d*)");
    private static final String QUOT = "&quot;";

    private JSonSchemaHelper() {
    }

    public static List<Map<String, String>> parseJsonSchema(String group, String json, boolean parseProperties) {
        String[] lines;
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (json == null) {
            return answer;
        }
        boolean found = false;
        for (String line : lines = json.split("\n")) {
            if (!found) {
                String s = line.trim();
                found = s.startsWith("\"" + group + "\":") && s.endsWith("{");
                continue;
            }
            if (line.equals("  },") || line.equals("  }")) break;
            line = line.replaceAll("\"\\\\\"\"", "\"&quot;\"");
            LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
            Matcher matcher = PATTERN.matcher(line);
            String key = parseProperties ? "name" : null;
            while (matcher.find()) {
                if (key == null) {
                    key = matcher.group(1);
                    continue;
                }
                String value = matcher.group(1);
                if (value != null) {
                    value = value.trim();
                    value = value.replaceAll(QUOT, "\"");
                    value = JSonSchemaHelper.decodeJson(value);
                }
                if (value == null && (value = matcher.group(2)) != null) {
                    value = value.replaceAll("\"", "");
                    value = value.replaceAll(", ", ",");
                    value = value.trim();
                }
                if (value == null) {
                    value = matcher.group(3);
                }
                if (value == null) {
                    value = matcher.group(4);
                }
                if (value != null) {
                    row.put(key, value);
                }
                key = null;
            }
            if (row.isEmpty()) continue;
            answer.add(row);
        }
        return answer;
    }

    private static String decodeJson(String value) {
        if ("\\\\".equals(value)) {
            value = "\\";
        }
        return value;
    }

    public static String getSafeValue(String key, List<Map<String, String>> rows) {
        for (Map<String, String> row : rows) {
            String value = row.get(key);
            if (value == null) continue;
            return value;
        }
        return "";
    }

    public static String getSafeValue(String key, Map<String, String> rows) {
        String value = rows.get(key);
        if (value != null) {
            return value;
        }
        return "";
    }

    public static String getPropertyDefaultValue(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String defaultValue = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("defaultValue")) {
                defaultValue = row.get("defaultValue");
            }
            if (!found) continue;
            return defaultValue;
        }
        return null;
    }

    public static String getPropertyJavaType(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String javaType = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("javaType")) {
                javaType = row.get("javaType");
            }
            if (!found) continue;
            return javaType;
        }
        return null;
    }

    public static String getPropertyType(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String type = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("type")) {
                type = row.get("type");
            }
            if (!found) continue;
            return type;
        }
        return null;
    }
}

