/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.ModelineFactory;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutesConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(RoutesConfigurer.class);
    private RoutesCollector routesCollector;
    private CamelBeanPostProcessor beanPostProcessor;
    private List<RoutesBuilder> routesBuilders;
    private String basePackageScan;
    private String routesBuilderClasses;
    private String javaRoutesExcludePattern;
    private String javaRoutesIncludePattern;
    private String routesExcludePattern;
    private String routesIncludePattern;
    private String routesSourceDir;

    public List<RoutesBuilder> getRoutesBuilders() {
        return this.routesBuilders;
    }

    public void setRoutesBuilders(List<RoutesBuilder> routesBuilders) {
        this.routesBuilders = routesBuilders;
    }

    public String getBasePackageScan() {
        return this.basePackageScan;
    }

    public void setBasePackageScan(String basePackageScan) {
        this.basePackageScan = basePackageScan;
    }

    public String getRoutesBuilderClasses() {
        return this.routesBuilderClasses;
    }

    public void setRoutesBuilderClasses(String routesBuilderClasses) {
        this.routesBuilderClasses = routesBuilderClasses;
    }

    public String getJavaRoutesExcludePattern() {
        return this.javaRoutesExcludePattern;
    }

    public void setJavaRoutesExcludePattern(String javaRoutesExcludePattern) {
        this.javaRoutesExcludePattern = javaRoutesExcludePattern;
    }

    public String getJavaRoutesIncludePattern() {
        return this.javaRoutesIncludePattern;
    }

    public void setJavaRoutesIncludePattern(String javaRoutesIncludePattern) {
        this.javaRoutesIncludePattern = javaRoutesIncludePattern;
    }

    public String getRoutesExcludePattern() {
        return this.routesExcludePattern;
    }

    public void setRoutesExcludePattern(String routesExcludePattern) {
        this.routesExcludePattern = routesExcludePattern;
    }

    public String getRoutesIncludePattern() {
        return this.routesIncludePattern;
    }

    public void setRoutesIncludePattern(String routesIncludePattern) {
        this.routesIncludePattern = routesIncludePattern;
    }

    public String getRoutesSourceDir() {
        return this.routesSourceDir;
    }

    public void setRoutesSourceDir(String routesSourceDir) {
        this.routesSourceDir = routesSourceDir;
    }

    public RoutesCollector getRoutesCollector() {
        return this.routesCollector;
    }

    public void setRoutesCollector(RoutesCollector routesCollector) {
        this.routesCollector = routesCollector;
    }

    public CamelBeanPostProcessor getBeanPostProcessor() {
        return this.beanPostProcessor;
    }

    public void setBeanPostProcessor(CamelBeanPostProcessor beanPostProcessor) {
        this.beanPostProcessor = beanPostProcessor;
    }

    public void configureRoutes(CamelContext camelContext) throws Exception {
        ArrayList<RoutesBuilder> routes = new ArrayList<RoutesBuilder>();
        if (this.getRoutesBuilders() != null) {
            routes.addAll(this.getRoutesBuilders());
        }
        if (this.getRoutesBuilderClasses() != null) {
            String[] routeClasses;
            for (String routeClass : routeClasses = this.getRoutesBuilderClasses().split(",")) {
                Class routeClazz = camelContext.getClassResolver().resolveClass(routeClass, RoutesBuilder.class);
                if (routeClazz == null) {
                    LOG.warn("Unable to resolve class: {}", (Object)routeClass);
                    continue;
                }
                RoutesBuilder builder = (RoutesBuilder)camelContext.getInjector().newInstance(routeClazz);
                routes.add(builder);
            }
        }
        if (this.getBasePackageScan() != null) {
            String[] pkgs = this.getBasePackageScan().split(",");
            Set set = PluginHelper.getPackageScanClassResolver((CamelContext)camelContext).findImplementations(RoutesBuilder.class, pkgs);
            for (Class routeClazz : set) {
                Object builder = camelContext.getInjector().newInstance(routeClazz);
                if (builder instanceof RoutesBuilder) {
                    routes.add((RoutesBuilder)builder);
                    continue;
                }
                LOG.warn("Class {} is not a RouteBuilder class", (Object)routeClazz);
            }
        }
        if (this.getRoutesCollector() != null) {
            try {
                LOG.debug("RoutesCollectorEnabled: {}", (Object)this.getRoutesCollector());
                Collection<RoutesBuilder> routesFromRegistry = this.getRoutesCollector().collectRoutesFromRegistry(camelContext, this.getJavaRoutesExcludePattern(), this.getJavaRoutesIncludePattern());
                routes.addAll(routesFromRegistry);
                if (LOG.isDebugEnabled() && !routesFromRegistry.isEmpty()) {
                    LOG.debug("Discovered {} additional RoutesBuilder from registry: {}", (Object)routesFromRegistry.size(), (Object)this.getRoutesIncludePattern());
                }
                StopWatch watch = new StopWatch();
                Collection<RoutesBuilder> routesFromDirectory = this.getRoutesCollector().collectRoutesFromDirectory(camelContext, this.getRoutesExcludePattern(), this.getRoutesIncludePattern());
                routes.addAll(routesFromDirectory);
                if (LOG.isDebugEnabled() && !routesFromDirectory.isEmpty()) {
                    LOG.debug("Loaded {} additional RoutesBuilder from: {} (took {})", new Object[]{routesFromDirectory.size(), this.getRoutesIncludePattern(), TimeUtils.printDuration((long)watch.taken(), (boolean)true)});
                }
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        if (this.getBeanPostProcessor() != null) {
            for (RoutesBuilder routeBuilder : routes) {
                this.getBeanPostProcessor().postProcessBeforeInitialization((Object)routeBuilder, routeBuilder.getClass().getName());
                this.getBeanPostProcessor().postProcessAfterInitialization((Object)routeBuilder, routeBuilder.getClass().getName());
            }
        }
        this.addDiscoveredRoutes(camelContext, routes);
    }

    private void addDiscoveredRoutes(CamelContext camelContext, List<RoutesBuilder> routes) throws Exception {
        routes.sort((Comparator<RoutesBuilder>)OrderedComparator.get());
        for (RoutesBuilder builder : routes) {
            if (!(builder instanceof RouteConfigurationsBuilder)) continue;
            RouteConfigurationsBuilder rcb = (RouteConfigurationsBuilder)builder;
            LOG.debug("Adding routes configurations into CamelContext from RouteConfigurationsBuilder: {}", (Object)rcb);
            camelContext.addRoutesConfigurations(rcb);
        }
        for (RoutesBuilder builder : routes) {
            LOG.debug("Adding routes into CamelContext from RoutesBuilder: {}", (Object)builder);
            camelContext.addRoutes(builder);
        }
        for (RoutesBuilder builder : routes) {
            LOG.debug("Adding templated routes into CamelContext from RoutesBuilder: {}", (Object)builder);
            camelContext.addTemplatedRoutes(builder);
        }
    }

    public void configureModeline(CamelContext camelContext) throws Exception {
        if (this.getRoutesCollector() == null) {
            return;
        }
        try {
            LOG.debug("RoutesCollectorEnabled: {}", (Object)this.getRoutesCollector());
            String pattern = this.getRoutesIncludePattern();
            String optionalPattern = null;
            if (pattern != null && pattern.contains("?optional=true")) {
                StringJoiner sj1 = new StringJoiner(",");
                StringJoiner sj2 = new StringJoiner(",");
                for (String p : pattern.split(",")) {
                    if (p.endsWith("?optional=true")) {
                        sj2.add(p.substring(0, p.length() - 14));
                        continue;
                    }
                    sj1.add(p);
                }
                pattern = sj1.length() > 0 ? sj1.toString() : null;
                String string = optionalPattern = sj2.length() > 0 ? sj2.toString() : null;
            }
            if (optionalPattern == null) {
                Collection<Resource> resources = this.getRoutesCollector().findRouteResourcesFromDirectory(camelContext, this.getRoutesExcludePattern(), pattern);
                this.doConfigureModeline(camelContext, resources, false);
            } else {
                Collection<Resource> resources = this.getRoutesCollector().findRouteResourcesFromDirectory(camelContext, this.getRoutesExcludePattern(), optionalPattern);
                this.doConfigureModeline(camelContext, resources, true);
                if (pattern != null) {
                    resources = this.getRoutesCollector().findRouteResourcesFromDirectory(camelContext, this.getRoutesExcludePattern(), pattern);
                    this.doConfigureModeline(camelContext, resources, false);
                }
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
    }

    protected void doConfigureModeline(CamelContext camelContext, Collection<Resource> resources, boolean optional) throws Exception {
        RoutesLoader loader = PluginHelper.getRoutesLoader((CamelContext)camelContext);
        if (camelContext.isModeline().booleanValue()) {
            ModelineFactory factory = PluginHelper.getModelineFactory((CamelContext)camelContext);
            for (Resource resource : resources) {
                LOG.debug("Parsing modeline: {}", (Object)resource);
                factory.parseModeline(resource);
            }
        }
        for (Resource resource : resources) {
            LOG.debug("Pre-parsing: {}", (Object)resource);
            loader.preParseRoute(resource, optional);
        }
    }
}

